/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.search.documents.SearchDocument;
import com.azure.search.documents.models.IndexAction;
import com.azure.search.documents.models.IndexActionType;
import com.azure.search.documents.models.IndexBatchBase;
import java.util.ArrayList;

public class IndexDocumentsBatch<T>
extends IndexBatchBase<T> {
    public IndexDocumentsBatch() {
        super(new ArrayList());
    }

    public IndexDocumentsBatch<T> addActions(Iterable<IndexAction<T>> actions) {
        actions.forEach(action -> this.getActions().add(action));
        return this;
    }

    public IndexDocumentsBatch<T> addUploadActions(Iterable<T> documents) {
        this.addDocumentActions(documents, IndexActionType.UPLOAD);
        return this;
    }

    public IndexDocumentsBatch<T> addDeleteActions(Iterable<T> documents) {
        this.addDocumentActions(documents, IndexActionType.DELETE);
        return this;
    }

    public IndexDocumentsBatch<T> addDeleteActions(String keyName, Iterable<String> keyValues) {
        for (String val : keyValues) {
            SearchDocument doc = new SearchDocument();
            doc.put(keyName, val);
            IndexAction<SearchDocument> indexAction = new IndexAction().setActionType(IndexActionType.DELETE).setDocument(doc);
            this.getActions().add(indexAction);
        }
        return this;
    }

    public IndexDocumentsBatch<T> addMergeActions(Iterable<T> documents) {
        this.addDocumentActions(documents, IndexActionType.MERGE);
        return this;
    }

    public IndexDocumentsBatch<T> addMergeOrUploadActions(Iterable<T> documents) {
        this.addDocumentActions(documents, IndexActionType.MERGE_OR_UPLOAD);
        return this;
    }

    private void addDocumentActions(Iterable<T> documents, IndexActionType actionType) {
        documents.forEach(d -> this.getActions().add(new IndexAction().setActionType(actionType).setDocument(d)));
    }
}

