/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.search.documents.indexes.implementation.models.TokenFilter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@odata\\.type")
@JsonTypeName(value="#Microsoft.Azure.Search.SynonymTokenFilter")
@JsonFlatten
public class SynonymTokenFilter
extends TokenFilter {
    @JsonProperty(value="synonyms", required=true)
    private List<String> synonyms;
    @JsonProperty(value="ignoreCase")
    private Boolean ignoreCase;
    @JsonProperty(value="expand")
    private Boolean expand;

    @JsonCreator
    public SynonymTokenFilter(@JsonProperty(value="name") String name, @JsonProperty(value="synonyms") List<String> synonyms) {
        super(name);
        this.synonyms = synonyms;
    }

    public List<String> getSynonyms() {
        return this.synonyms;
    }

    public Boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public SynonymTokenFilter setIgnoreCase(Boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    public Boolean isExpand() {
        return this.expand;
    }

    public SynonymTokenFilter setExpand(Boolean expand) {
        this.expand = expand;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getSynonyms() == null) {
            throw new IllegalArgumentException("Missing required property synonyms in model SynonymTokenFilter");
        }
    }
}

