/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.search.documents.indexes.implementation.models.AzureActiveDirectoryApplicationCredentials;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SearchResourceEncryptionKey {
    @JsonProperty(value="keyVaultKeyName", required=true)
    private String keyName;
    @JsonProperty(value="keyVaultKeyVersion", required=true)
    private String keyVersion;
    @JsonProperty(value="keyVaultUri", required=true)
    private String vaultUri;
    @JsonProperty(value="accessCredentials")
    private AzureActiveDirectoryApplicationCredentials accessCredentials;

    @JsonCreator
    public SearchResourceEncryptionKey(@JsonProperty(value="keyVaultKeyName") String keyName, @JsonProperty(value="keyVaultKeyVersion") String keyVersion, @JsonProperty(value="keyVaultUri") String vaultUri) {
        this.keyName = keyName;
        this.keyVersion = keyVersion;
        this.vaultUri = vaultUri;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getKeyVersion() {
        return this.keyVersion;
    }

    public String getVaultUri() {
        return this.vaultUri;
    }

    public AzureActiveDirectoryApplicationCredentials getAccessCredentials() {
        return this.accessCredentials;
    }

    public SearchResourceEncryptionKey setAccessCredentials(AzureActiveDirectoryApplicationCredentials accessCredentials) {
        this.accessCredentials = accessCredentials;
        return this;
    }

    public void validate() {
        if (this.getKeyName() == null) {
            throw new IllegalArgumentException("Missing required property keyName in model SearchResourceEncryptionKey");
        }
        if (this.getKeyVersion() == null) {
            throw new IllegalArgumentException("Missing required property keyVersion in model SearchResourceEncryptionKey");
        }
        if (this.getVaultUri() == null) {
            throw new IllegalArgumentException("Missing required property vaultUri in model SearchResourceEncryptionKey");
        }
        if (this.getAccessCredentials() != null) {
            this.getAccessCredentials().validate();
        }
    }
}

