/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.search.documents.indexes.implementation.models.CharFilter;
import com.azure.search.documents.indexes.implementation.models.CorsOptions;
import com.azure.search.documents.indexes.implementation.models.LexicalAnalyzer;
import com.azure.search.documents.indexes.implementation.models.LexicalTokenizer;
import com.azure.search.documents.indexes.implementation.models.ScoringProfile;
import com.azure.search.documents.indexes.implementation.models.SearchField;
import com.azure.search.documents.indexes.implementation.models.SearchResourceEncryptionKey;
import com.azure.search.documents.indexes.implementation.models.Similarity;
import com.azure.search.documents.indexes.implementation.models.Suggester;
import com.azure.search.documents.indexes.implementation.models.TokenFilter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class SearchIndex {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="fields", required=true)
    private List<SearchField> fields;
    @JsonProperty(value="scoringProfiles")
    private List<ScoringProfile> scoringProfiles;
    @JsonProperty(value="defaultScoringProfile")
    private String defaultScoringProfile;
    @JsonProperty(value="corsOptions")
    private CorsOptions corsOptions;
    @JsonProperty(value="suggesters")
    private List<Suggester> suggesters;
    @JsonProperty(value="analyzers")
    private List<LexicalAnalyzer> analyzers;
    @JsonProperty(value="tokenizers")
    private List<LexicalTokenizer> tokenizers;
    @JsonProperty(value="tokenFilters")
    private List<TokenFilter> tokenFilters;
    @JsonProperty(value="charFilters")
    private List<CharFilter> charFilters;
    @JsonProperty(value="encryptionKey")
    private SearchResourceEncryptionKey encryptionKey;
    @JsonProperty(value="similarity")
    private Similarity similarity;
    @JsonProperty(value="@odata.etag")
    private String eTag;

    @JsonCreator
    public SearchIndex(@JsonProperty(value="name") String name, @JsonProperty(value="fields") List<SearchField> fields) {
        this.name = name;
        this.fields = fields;
    }

    public String getName() {
        return this.name;
    }

    public List<SearchField> getFields() {
        return this.fields;
    }

    public List<ScoringProfile> getScoringProfiles() {
        return this.scoringProfiles;
    }

    public SearchIndex setScoringProfiles(List<ScoringProfile> scoringProfiles) {
        this.scoringProfiles = scoringProfiles;
        return this;
    }

    public String getDefaultScoringProfile() {
        return this.defaultScoringProfile;
    }

    public SearchIndex setDefaultScoringProfile(String defaultScoringProfile) {
        this.defaultScoringProfile = defaultScoringProfile;
        return this;
    }

    public CorsOptions getCorsOptions() {
        return this.corsOptions;
    }

    public SearchIndex setCorsOptions(CorsOptions corsOptions) {
        this.corsOptions = corsOptions;
        return this;
    }

    public List<Suggester> getSuggesters() {
        return this.suggesters;
    }

    public SearchIndex setSuggesters(List<Suggester> suggesters) {
        this.suggesters = suggesters;
        return this;
    }

    public List<LexicalAnalyzer> getAnalyzers() {
        return this.analyzers;
    }

    public SearchIndex setAnalyzers(List<LexicalAnalyzer> analyzers) {
        this.analyzers = analyzers;
        return this;
    }

    public List<LexicalTokenizer> getTokenizers() {
        return this.tokenizers;
    }

    public SearchIndex setTokenizers(List<LexicalTokenizer> tokenizers) {
        this.tokenizers = tokenizers;
        return this;
    }

    public List<TokenFilter> getTokenFilters() {
        return this.tokenFilters;
    }

    public SearchIndex setTokenFilters(List<TokenFilter> tokenFilters) {
        this.tokenFilters = tokenFilters;
        return this;
    }

    public List<CharFilter> getCharFilters() {
        return this.charFilters;
    }

    public SearchIndex setCharFilters(List<CharFilter> charFilters) {
        this.charFilters = charFilters;
        return this;
    }

    public SearchResourceEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public SearchIndex setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public SearchIndex setSimilarity(Similarity similarity) {
        this.similarity = similarity;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public SearchIndex setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public void validate() {
        if (this.getName() == null) {
            throw new IllegalArgumentException("Missing required property name in model SearchIndex");
        }
        if (this.getFields() == null) {
            throw new IllegalArgumentException("Missing required property fields in model SearchIndex");
        }
        this.getFields().forEach(e -> e.validate());
        if (this.getScoringProfiles() != null) {
            this.getScoringProfiles().forEach(e -> e.validate());
        }
        if (this.getCorsOptions() != null) {
            this.getCorsOptions().validate();
        }
        if (this.getSuggesters() != null) {
            this.getSuggesters().forEach(e -> e.validate());
        }
        if (this.getAnalyzers() != null) {
            this.getAnalyzers().forEach(e -> e.validate());
        }
        if (this.getTokenizers() != null) {
            this.getTokenizers().forEach(e -> e.validate());
        }
        if (this.getTokenFilters() != null) {
            this.getTokenFilters().forEach(e -> e.validate());
        }
        if (this.getCharFilters() != null) {
            this.getCharFilters().forEach(e -> e.validate());
        }
        if (this.getEncryptionKey() != null) {
            this.getEncryptionKey().validate();
        }
        if (this.getSimilarity() != null) {
            this.getSimilarity().validate();
        }
    }
}

