/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.search.documents.indexes.implementation.models.LexicalAnalyzerName;
import com.azure.search.documents.indexes.implementation.models.SearchFieldDataType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class SearchField {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="type", required=true)
    private SearchFieldDataType type;
    @JsonProperty(value="key")
    private Boolean key;
    @JsonProperty(value="retrievable")
    private Boolean retrievable;
    @JsonProperty(value="searchable")
    private Boolean searchable;
    @JsonProperty(value="filterable")
    private Boolean filterable;
    @JsonProperty(value="sortable")
    private Boolean sortable;
    @JsonProperty(value="facetable")
    private Boolean facetable;
    @JsonProperty(value="analyzer")
    private LexicalAnalyzerName analyzer;
    @JsonProperty(value="searchAnalyzer")
    private LexicalAnalyzerName searchAnalyzer;
    @JsonProperty(value="indexAnalyzer")
    private LexicalAnalyzerName indexAnalyzer;
    @JsonProperty(value="synonymMaps")
    private List<String> synonymMaps;
    @JsonProperty(value="fields")
    private List<SearchField> fields;

    @JsonCreator
    public SearchField(@JsonProperty(value="name") String name, @JsonProperty(value="type") SearchFieldDataType type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public SearchFieldDataType getType() {
        return this.type;
    }

    public Boolean isKey() {
        return this.key;
    }

    public SearchField setKey(Boolean key) {
        this.key = key;
        return this;
    }

    public Boolean isRetrievable() {
        return this.retrievable;
    }

    public SearchField setRetrievable(Boolean retrievable) {
        this.retrievable = retrievable;
        return this;
    }

    public Boolean isSearchable() {
        return this.searchable;
    }

    public SearchField setSearchable(Boolean searchable) {
        this.searchable = searchable;
        return this;
    }

    public Boolean isFilterable() {
        return this.filterable;
    }

    public SearchField setFilterable(Boolean filterable) {
        this.filterable = filterable;
        return this;
    }

    public Boolean isSortable() {
        return this.sortable;
    }

    public SearchField setSortable(Boolean sortable) {
        this.sortable = sortable;
        return this;
    }

    public Boolean isFacetable() {
        return this.facetable;
    }

    public SearchField setFacetable(Boolean facetable) {
        this.facetable = facetable;
        return this;
    }

    public LexicalAnalyzerName getAnalyzer() {
        return this.analyzer;
    }

    public SearchField setAnalyzer(LexicalAnalyzerName analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public LexicalAnalyzerName getSearchAnalyzer() {
        return this.searchAnalyzer;
    }

    public SearchField setSearchAnalyzer(LexicalAnalyzerName searchAnalyzer) {
        this.searchAnalyzer = searchAnalyzer;
        return this;
    }

    public LexicalAnalyzerName getIndexAnalyzer() {
        return this.indexAnalyzer;
    }

    public SearchField setIndexAnalyzer(LexicalAnalyzerName indexAnalyzer) {
        this.indexAnalyzer = indexAnalyzer;
        return this;
    }

    public List<String> getSynonymMaps() {
        return this.synonymMaps;
    }

    public SearchField setSynonymMaps(List<String> synonymMaps) {
        this.synonymMaps = synonymMaps;
        return this;
    }

    public List<SearchField> getFields() {
        return this.fields;
    }

    public SearchField setFields(List<SearchField> fields) {
        this.fields = fields;
        return this;
    }

    public void validate() {
        if (this.getName() == null) {
            throw new IllegalArgumentException("Missing required property name in model SearchField");
        }
        if (this.getType() == null) {
            throw new IllegalArgumentException("Missing required property type in model SearchField");
        }
        if (this.getFields() != null) {
            this.getFields().forEach(e -> e.validate());
        }
    }
}

