/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.search.documents.indexes.implementation.models.CharFilterName;
import com.azure.search.documents.indexes.implementation.models.LexicalAnalyzer;
import com.azure.search.documents.indexes.implementation.models.LexicalTokenizerName;
import com.azure.search.documents.indexes.implementation.models.TokenFilterName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@odata\\.type")
@JsonTypeName(value="#Microsoft.Azure.Search.CustomAnalyzer")
@JsonFlatten
public class CustomAnalyzer
extends LexicalAnalyzer {
    @JsonProperty(value="tokenizer", required=true)
    private LexicalTokenizerName tokenizer;
    @JsonProperty(value="tokenFilters")
    private List<TokenFilterName> tokenFilters;
    @JsonProperty(value="charFilters")
    private List<CharFilterName> charFilters;

    @JsonCreator
    public CustomAnalyzer(@JsonProperty(value="name") String name, @JsonProperty(value="tokenizer") LexicalTokenizerName tokenizer) {
        super(name);
        this.tokenizer = tokenizer;
    }

    public LexicalTokenizerName getTokenizer() {
        return this.tokenizer;
    }

    public List<TokenFilterName> getTokenFilters() {
        return this.tokenFilters;
    }

    public CustomAnalyzer setTokenFilters(List<TokenFilterName> tokenFilters) {
        this.tokenFilters = tokenFilters;
        return this;
    }

    public List<CharFilterName> getCharFilters() {
        return this.charFilters;
    }

    public CustomAnalyzer setCharFilters(List<CharFilterName> charFilters) {
        this.charFilters = charFilters;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getTokenizer() == null) {
            throw new IllegalArgumentException("Missing required property tokenizer in model CustomAnalyzer");
        }
    }
}

