/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.indexes.implementation.SearchServiceClientImpl;

@ServiceClientBuilder(serviceClients={SearchServiceClientImpl.class})
public final class SearchServiceClientImplBuilder {
    private String endpoint;
    private HttpPipeline pipeline;
    private SerializerAdapter serializerAdapter;

    public SearchServiceClientImplBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public SearchServiceClientImplBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public SearchServiceClientImplBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public SearchServiceClientImpl buildClient() {
        if (this.pipeline == null) {
            this.pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build();
        }
        if (this.serializerAdapter == null) {
            this.serializerAdapter = JacksonAdapter.createDefaultSerializerAdapter();
        }
        SearchServiceClientImpl client = new SearchServiceClientImpl(this.pipeline, this.serializerAdapter, this.endpoint);
        return client;
    }
}

