/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.indexes.implementation.SearchServiceClientImpl;
import com.azure.search.documents.indexes.implementation.models.ListDataSourcesResult;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.implementation.models.SearchErrorException;
import com.azure.search.documents.indexes.implementation.models.SearchIndexerDataSource;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class DataSourcesImpl {
    private final DataSourcesService service;
    private final SearchServiceClientImpl client;

    DataSourcesImpl(SearchServiceClientImpl client) {
        this.service = (DataSourcesService)RestProxy.create(DataSourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public Mono<Response<SearchIndexerDataSource>> createOrUpdateWithResponseAsync(String dataSourceName, SearchIndexerDataSource dataSource, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (dataSourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataSourceName is required and cannot be null."));
        }
        if (dataSource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataSource is required and cannot be null."));
        }
        dataSource.validate();
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdate(this.client.getEndpoint(), dataSourceName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), "application/json; odata.metadata=minimal", dataSource, context);
    }

    public Mono<Response<Void>> deleteWithResponseAsync(String dataSourceName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (dataSourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataSourceName is required and cannot be null."));
        }
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.delete(this.client.getEndpoint(), dataSourceName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    public Mono<Response<SearchIndexerDataSource>> getWithResponseAsync(String dataSourceName, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (dataSourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataSourceName is required and cannot be null."));
        }
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.get(this.client.getEndpoint(), dataSourceName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    public Mono<Response<ListDataSourcesResult>> listWithResponseAsync(String select, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.list(this.client.getEndpoint(), select, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    public Mono<Response<SearchIndexerDataSource>> createWithResponseAsync(SearchIndexerDataSource dataSource, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (dataSource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataSource is required and cannot be null."));
        }
        dataSource.validate();
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.create(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", dataSource, context);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="SearchServiceClientD")
    private static interface DataSourcesService {
        @Put(value="/datasources('{dataSourceName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SearchIndexerDataSource>> createOrUpdate(@HostParam(value="endpoint") String var1, @PathParam(value="dataSourceName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @HeaderParam(value="Prefer") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="accept") String var8, @BodyParam(value="application/json") SearchIndexerDataSource var9, Context var10);

        @Delete(value="/datasources('{dataSourceName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="dataSourceName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="accept") String var7, Context var8);

        @Get(value="/datasources('{dataSourceName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SearchIndexerDataSource>> get(@HostParam(value="endpoint") String var1, @PathParam(value="dataSourceName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept") String var5, Context var6);

        @Get(value="/datasources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<ListDataSourcesResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="$select") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept") String var5, Context var6);

        @Post(value="/datasources")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SearchIndexerDataSource>> create(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept") String var4, @BodyParam(value="application/json") SearchIndexerDataSource var5, Context var6);
    }
}

