/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.search.documents.indexes.SearchIndexerAsyncClient;
import com.azure.search.documents.indexes.models.SearchIndexer;
import com.azure.search.documents.indexes.models.SearchIndexerDataSourceConnection;
import com.azure.search.documents.indexes.models.SearchIndexerSkillset;
import com.azure.search.documents.indexes.models.SearchIndexerStatus;

public class SearchIndexerClient {
    private final SearchIndexerAsyncClient asyncClient;

    SearchIndexerClient(SearchIndexerAsyncClient searchIndexerAsyncClient) {
        this.asyncClient = searchIndexerAsyncClient;
    }

    HttpPipeline getHttpPipeline() {
        return this.asyncClient.getHttpPipeline();
    }

    public String getEndpoint() {
        return this.asyncClient.getEndpoint();
    }

    public SearchIndexerDataSourceConnection createOrUpdateDataSourceConnection(SearchIndexerDataSourceConnection dataSourceConnection) {
        return (SearchIndexerDataSourceConnection)this.createOrUpdateDataSourceConnectionWithResponse(dataSourceConnection, false, Context.NONE).getValue();
    }

    public Response<SearchIndexerDataSourceConnection> createOrUpdateDataSourceConnectionWithResponse(SearchIndexerDataSourceConnection dataSourceConnection, boolean onlyIfUnchanged, Context context) {
        return (Response)this.asyncClient.createOrUpdateDataSourceConnectionWithResponse(dataSourceConnection, onlyIfUnchanged, context).block();
    }

    public SearchIndexerDataSourceConnection createDataSourceConnection(SearchIndexerDataSourceConnection dataSourceConnection) {
        return (SearchIndexerDataSourceConnection)this.createDataSourceConnectionWithResponse(dataSourceConnection, Context.NONE).getValue();
    }

    public Response<SearchIndexerDataSourceConnection> createDataSourceConnectionWithResponse(SearchIndexerDataSourceConnection dataSourceConnection, Context context) {
        return (Response)this.asyncClient.createDataSourceConnectionWithResponse(dataSourceConnection, context).block();
    }

    public SearchIndexerDataSourceConnection getDataSourceConnection(String dataSourceConnectionName) {
        return (SearchIndexerDataSourceConnection)this.getDataSourceConnectionWithResponse(dataSourceConnectionName, Context.NONE).getValue();
    }

    public Response<SearchIndexerDataSourceConnection> getDataSourceConnectionWithResponse(String dataSourceConnectionName, Context context) {
        return (Response)this.asyncClient.getDataSourceConnectionWithResponse(dataSourceConnectionName, context).block();
    }

    public PagedIterable<SearchIndexerDataSourceConnection> listDataSourceConnections() {
        return this.listDataSourceConnections(Context.NONE);
    }

    public PagedIterable<SearchIndexerDataSourceConnection> listDataSourceConnections(Context context) {
        return new PagedIterable(this.asyncClient.listDataSourceConnections(context));
    }

    public PagedIterable<String> listDataSourceConnectionNames() {
        return this.listDataSourceConnectionNames(Context.NONE);
    }

    public PagedIterable<String> listDataSourceConnectionNames(Context context) {
        return new PagedIterable(this.asyncClient.listDataSourceConnectionNames(context));
    }

    public void deleteDataSourceConnection(String dataSourceConnectionName) {
        this.deleteDataSourceConnectionWithResponse(new SearchIndexerDataSourceConnection(dataSourceConnectionName), false, Context.NONE);
    }

    public Response<Void> deleteDataSourceConnectionWithResponse(SearchIndexerDataSourceConnection dataSourceConnection, boolean onlyIfUnchanged, Context context) {
        String etag = onlyIfUnchanged ? dataSourceConnection.getETag() : null;
        return (Response)this.asyncClient.deleteDataSourceConnectionWithResponse(dataSourceConnection.getName(), etag, context).block();
    }

    public SearchIndexer createIndexer(SearchIndexer indexer) {
        return (SearchIndexer)this.createIndexerWithResponse(indexer, Context.NONE).getValue();
    }

    public Response<SearchIndexer> createIndexerWithResponse(SearchIndexer indexer, Context context) {
        return (Response)this.asyncClient.createIndexerWithResponse(indexer, context).block();
    }

    public SearchIndexer createOrUpdateIndexer(SearchIndexer indexer) {
        return (SearchIndexer)this.createOrUpdateIndexerWithResponse(indexer, false, Context.NONE).getValue();
    }

    public Response<SearchIndexer> createOrUpdateIndexerWithResponse(SearchIndexer indexer, boolean onlyIfUnchanged, Context context) {
        return (Response)this.asyncClient.createOrUpdateIndexerWithResponse(indexer, onlyIfUnchanged, context).block();
    }

    public PagedIterable<SearchIndexer> listIndexers() {
        return this.listIndexers(Context.NONE);
    }

    public PagedIterable<SearchIndexer> listIndexers(Context context) {
        return new PagedIterable(this.asyncClient.listIndexers(context));
    }

    public PagedIterable<String> listIndexerNames() {
        return this.listIndexerNames(Context.NONE);
    }

    public PagedIterable<String> listIndexerNames(Context context) {
        return new PagedIterable(this.asyncClient.listIndexerNames(context));
    }

    public SearchIndexer getIndexer(String indexerName) {
        return (SearchIndexer)this.getIndexerWithResponse(indexerName, Context.NONE).getValue();
    }

    public Response<SearchIndexer> getIndexerWithResponse(String indexerName, Context context) {
        return (Response)this.asyncClient.getIndexerWithResponse(indexerName, context).block();
    }

    public void deleteIndexer(String indexerName) {
        this.deleteIndexerWithResponse(new SearchIndexer(indexerName), false, Context.NONE);
    }

    public Response<Void> deleteIndexerWithResponse(SearchIndexer indexer, boolean onlyIfUnchanged, Context context) {
        String etag = onlyIfUnchanged ? indexer.getETag() : null;
        return (Response)this.asyncClient.deleteIndexerWithResponse(indexer.getName(), etag, context).block();
    }

    public void resetIndexer(String indexerName) {
        this.resetIndexerWithResponse(indexerName, Context.NONE);
    }

    public Response<Void> resetIndexerWithResponse(String indexerName, Context context) {
        return (Response)this.asyncClient.resetIndexerWithResponse(indexerName, context).block();
    }

    public void runIndexer(String indexerName) {
        this.runIndexerWithResponse(indexerName, Context.NONE);
    }

    public Response<Void> runIndexerWithResponse(String indexerName, Context context) {
        return (Response)this.asyncClient.runIndexerWithResponse(indexerName, context).block();
    }

    public SearchIndexerStatus getIndexerStatus(String indexerName) {
        return (SearchIndexerStatus)this.getIndexerStatusWithResponse(indexerName, Context.NONE).getValue();
    }

    public Response<SearchIndexerStatus> getIndexerStatusWithResponse(String indexerName, Context context) {
        return (Response)this.asyncClient.getIndexerStatusWithResponse(indexerName, context).block();
    }

    public SearchIndexerSkillset createSkillset(SearchIndexerSkillset skillset) {
        return (SearchIndexerSkillset)this.createSkillsetWithResponse(skillset, Context.NONE).getValue();
    }

    public Response<SearchIndexerSkillset> createSkillsetWithResponse(SearchIndexerSkillset skillset, Context context) {
        return (Response)this.asyncClient.createSkillsetWithResponse(skillset, context).block();
    }

    public SearchIndexerSkillset getSkillset(String skillsetName) {
        return (SearchIndexerSkillset)this.getSkillsetWithResponse(skillsetName, Context.NONE).getValue();
    }

    public Response<SearchIndexerSkillset> getSkillsetWithResponse(String skillsetName, Context context) {
        return (Response)this.asyncClient.getSkillsetWithResponse(skillsetName, context).block();
    }

    public PagedIterable<SearchIndexerSkillset> listSkillsets() {
        return this.listSkillsets(Context.NONE);
    }

    public PagedIterable<SearchIndexerSkillset> listSkillsets(Context context) {
        return new PagedIterable(this.asyncClient.listSkillsets(context));
    }

    public PagedIterable<String> listSkillsetNames() {
        return this.listSkillsetNames(Context.NONE);
    }

    public PagedIterable<String> listSkillsetNames(Context context) {
        return new PagedIterable(this.asyncClient.listSkillsetNames(context));
    }

    public SearchIndexerSkillset createOrUpdateSkillset(SearchIndexerSkillset skillset) {
        return (SearchIndexerSkillset)this.createOrUpdateSkillsetWithResponse(skillset, false, Context.NONE).getValue();
    }

    public Response<SearchIndexerSkillset> createOrUpdateSkillsetWithResponse(SearchIndexerSkillset skillset, boolean onlyIfUnchanged, Context context) {
        return (Response)this.asyncClient.createOrUpdateSkillsetWithResponse(skillset, onlyIfUnchanged, context).block();
    }

    public void deleteSkillset(String skillsetName) {
        this.deleteSkillsetWithResponse(new SearchIndexerSkillset(skillsetName), false, Context.NONE);
    }

    public Response<Void> deleteSkillsetWithResponse(SearchIndexerSkillset skillset, boolean onlyIfUnchanged, Context context) {
        String etag = onlyIfUnchanged ? skillset.getETag() : null;
        return (Response)this.asyncClient.deleteSkillsetWithResponse(skillset.getName(), etag, context).block();
    }
}

