/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.search.documents.SearchClient;
import com.azure.search.documents.indexes.SearchIndexAsyncClient;
import com.azure.search.documents.indexes.models.AnalyzeTextOptions;
import com.azure.search.documents.indexes.models.AnalyzedTokenInfo;
import com.azure.search.documents.indexes.models.FieldBuilderOptions;
import com.azure.search.documents.indexes.models.SearchField;
import com.azure.search.documents.indexes.models.SearchIndex;
import com.azure.search.documents.indexes.models.SearchIndexStatistics;
import com.azure.search.documents.indexes.models.SearchServiceStatistics;
import com.azure.search.documents.indexes.models.SynonymMap;
import java.util.List;

public final class SearchIndexClient {
    private final SearchIndexAsyncClient asyncClient;

    SearchIndexClient(SearchIndexAsyncClient searchIndexAsyncClient) {
        this.asyncClient = searchIndexAsyncClient;
    }

    HttpPipeline getHttpPipeline() {
        return this.asyncClient.getHttpPipeline();
    }

    public String getEndpoint() {
        return this.asyncClient.getEndpoint();
    }

    public SearchClient getSearchClient(String indexName) {
        return this.asyncClient.getSearchClientBuilder(indexName).buildClient();
    }

    public SearchIndex createIndex(SearchIndex index) {
        return (SearchIndex)this.createIndexWithResponse(index, Context.NONE).getValue();
    }

    public Response<SearchIndex> createIndexWithResponse(SearchIndex index, Context context) {
        return (Response)this.asyncClient.createIndexWithResponse(index, context).block();
    }

    public SearchIndex getIndex(String indexName) {
        return (SearchIndex)this.getIndexWithResponse(indexName, Context.NONE).getValue();
    }

    public Response<SearchIndex> getIndexWithResponse(String indexName, Context context) {
        return (Response)this.asyncClient.getIndexWithResponse(indexName, context).block();
    }

    public SearchIndexStatistics getIndexStatistics(String indexName) {
        return (SearchIndexStatistics)this.getIndexStatisticsWithResponse(indexName, Context.NONE).getValue();
    }

    public Response<SearchIndexStatistics> getIndexStatisticsWithResponse(String indexName, Context context) {
        return (Response)this.asyncClient.getIndexStatisticsWithResponse(indexName, context).block();
    }

    public PagedIterable<SearchIndex> listIndexes() {
        return this.listIndexes(Context.NONE);
    }

    public PagedIterable<SearchIndex> listIndexes(Context context) {
        return new PagedIterable(this.asyncClient.listIndexes(context));
    }

    public PagedIterable<String> listIndexNames() {
        return this.listIndexNames(Context.NONE);
    }

    public PagedIterable<String> listIndexNames(Context context) {
        return new PagedIterable(this.asyncClient.listIndexNames(context));
    }

    public SearchIndex createOrUpdateIndex(SearchIndex index) {
        return (SearchIndex)this.createOrUpdateIndexWithResponse(index, false, false, Context.NONE).getValue();
    }

    public Response<SearchIndex> createOrUpdateIndexWithResponse(SearchIndex index, boolean allowIndexDowntime, boolean onlyIfUnchanged, Context context) {
        return (Response)this.asyncClient.createOrUpdateIndexWithResponse(index, allowIndexDowntime, onlyIfUnchanged, context).block();
    }

    public void deleteIndex(String indexName) {
        this.deleteIndexWithResponse(new SearchIndex(indexName), false, Context.NONE);
    }

    public Response<Void> deleteIndexWithResponse(SearchIndex index, boolean onlyIfUnchanged, Context context) {
        String etag = onlyIfUnchanged ? index.getETag() : null;
        return (Response)this.asyncClient.deleteIndexWithResponse(index.getName(), etag, context).block();
    }

    public PagedIterable<AnalyzedTokenInfo> analyzeText(String indexName, AnalyzeTextOptions analyzeTextOptions) {
        return this.analyzeText(indexName, analyzeTextOptions, Context.NONE);
    }

    public PagedIterable<AnalyzedTokenInfo> analyzeText(String indexName, AnalyzeTextOptions analyzeTextOptions, Context context) {
        return new PagedIterable(this.asyncClient.analyzeText(indexName, analyzeTextOptions, context));
    }

    public SynonymMap createSynonymMap(SynonymMap synonymMap) {
        return (SynonymMap)this.createSynonymMapWithResponse(synonymMap, Context.NONE).getValue();
    }

    public Response<SynonymMap> createSynonymMapWithResponse(SynonymMap synonymMap, Context context) {
        return (Response)this.asyncClient.createSynonymMapWithResponse(synonymMap, context).block();
    }

    public SynonymMap getSynonymMap(String synonymMapName) {
        return (SynonymMap)this.getSynonymMapWithResponse(synonymMapName, Context.NONE).getValue();
    }

    public Response<SynonymMap> getSynonymMapWithResponse(String synonymMapName, Context context) {
        return (Response)this.asyncClient.getSynonymMapWithResponse(synonymMapName, context).block();
    }

    public PagedIterable<SynonymMap> listSynonymMaps() {
        return this.listSynonymMaps(Context.NONE);
    }

    public PagedIterable<SynonymMap> listSynonymMaps(Context context) {
        return new PagedIterable(this.asyncClient.listSynonymMaps(context));
    }

    public PagedIterable<String> listSynonymMapNames() {
        return this.listSynonymMapNames(Context.NONE);
    }

    public PagedIterable<String> listSynonymMapNames(Context context) {
        return new PagedIterable(this.asyncClient.listSynonymMapNames(context));
    }

    public SynonymMap createOrUpdateSynonymMap(SynonymMap synonymMap) {
        return (SynonymMap)this.createOrUpdateSynonymMapWithResponse(synonymMap, false, Context.NONE).getValue();
    }

    public Response<SynonymMap> createOrUpdateSynonymMapWithResponse(SynonymMap synonymMap, boolean onlyIfUnchanged, Context context) {
        return (Response)this.asyncClient.createOrUpdateSynonymMapWithResponse(synonymMap, onlyIfUnchanged, context).block();
    }

    public void deleteSynonymMap(String synonymMapName) {
        this.deleteSynonymMapWithResponse(new SynonymMap(synonymMapName), false, Context.NONE);
    }

    public Response<Void> deleteSynonymMapWithResponse(SynonymMap synonymMap, boolean onlyIfUnchanged, Context context) {
        String etag = onlyIfUnchanged ? synonymMap.getETag() : null;
        return (Response)this.asyncClient.deleteSynonymMapWithResponse(synonymMap.getName(), etag, context).block();
    }

    public SearchServiceStatistics getServiceStatistics() {
        return (SearchServiceStatistics)this.getServiceStatisticsWithResponse(Context.NONE).getValue();
    }

    public Response<SearchServiceStatistics> getServiceStatisticsWithResponse(Context context) {
        return (Response)this.asyncClient.getServiceStatisticsWithResponse(context).block();
    }

    public static List<SearchField> buildSearchFields(Class<?> model, FieldBuilderOptions options) {
        return SearchIndexAsyncClient.buildSearchFields(model, options);
    }
}

