/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.util;

import com.azure.core.util.logging.ClientLogger;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class PrivateFieldAccessHelper {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateFieldAccessHelper.class);

    public static <T> void set(T obj, String fieldName, Object value) {
        try {
            final Field field = obj.getClass().getDeclaredField(fieldName);
            if (!field.isAccessible()) {
                AccessController.doPrivileged(new PrivilegedAction<T>(){

                    @Override
                    public T run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
            }
            field.set(obj, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    public static <T, I> I get(T obj, String fieldName, Class<I> outputClass) {
        try {
            final Field field = obj.getClass().getDeclaredField(fieldName);
            if (!field.isAccessible()) {
                AccessController.doPrivileged(new PrivilegedAction<T>(){

                    @Override
                    public T run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
            }
            return (I)field.get(obj);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }
}

