/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.models;

import com.azure.search.documents.implementation.models.FacetResult;
import com.azure.search.documents.implementation.models.SearchRequest;
import com.azure.search.documents.implementation.models.SearchResult;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class SearchDocumentsResult {
    @JsonProperty(value="@odata.count", access=JsonProperty.Access.WRITE_ONLY)
    private Long count;
    @JsonProperty(value="@search.coverage", access=JsonProperty.Access.WRITE_ONLY)
    private Double coverage;
    @JsonProperty(value="@search.facets", access=JsonProperty.Access.WRITE_ONLY)
    private Map<String, List<FacetResult>> facets;
    @JsonProperty(value="@search.nextPageParameters", access=JsonProperty.Access.WRITE_ONLY)
    private SearchRequest nextPageParameters;
    @JsonProperty(value="value", required=true, access=JsonProperty.Access.WRITE_ONLY)
    private List<SearchResult> results;
    @JsonProperty(value="@odata.nextLink", access=JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    @JsonCreator
    public SearchDocumentsResult(@JsonProperty(value="value") List<SearchResult> results) {
        this.results = results;
    }

    public Long getCount() {
        return this.count;
    }

    public Double getCoverage() {
        return this.coverage;
    }

    public Map<String, List<FacetResult>> getFacets() {
        return this.facets;
    }

    public SearchRequest getNextPageParameters() {
        return this.nextPageParameters;
    }

    public List<SearchResult> getResults() {
        return this.results;
    }

    public String getNextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.getFacets() != null) {
            this.getFacets().values().forEach(e -> {
                if (e != null) {
                    e.forEach(e1 -> e1.validate());
                }
            });
        }
        if (this.getNextPageParameters() != null) {
            this.getNextPageParameters().validate();
        }
        if (this.getResults() != null) {
            this.getResults().forEach(e -> e.validate());
        }
    }
}

