/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.models;

import com.azure.search.documents.implementation.models.AutocompleteMode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class AutocompleteRequest {
    @JsonProperty(value="search", required=true)
    private String searchText;
    @JsonProperty(value="autocompleteMode")
    private AutocompleteMode autocompleteMode;
    @JsonProperty(value="filter")
    private String filter;
    @JsonProperty(value="fuzzy")
    private Boolean useFuzzyMatching;
    @JsonProperty(value="highlightPostTag")
    private String highlightPostTag;
    @JsonProperty(value="highlightPreTag")
    private String highlightPreTag;
    @JsonProperty(value="minimumCoverage")
    private Double minimumCoverage;
    @JsonProperty(value="searchFields")
    private String searchFields;
    @JsonProperty(value="suggesterName", required=true)
    private String suggesterName;
    @JsonProperty(value="top")
    private Integer top;

    @JsonCreator
    public AutocompleteRequest(@JsonProperty(value="search") String searchText, @JsonProperty(value="suggesterName") String suggesterName) {
        this.searchText = searchText;
        this.suggesterName = suggesterName;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public AutocompleteMode getAutocompleteMode() {
        return this.autocompleteMode;
    }

    public AutocompleteRequest setAutocompleteMode(AutocompleteMode autocompleteMode) {
        this.autocompleteMode = autocompleteMode;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public AutocompleteRequest setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public Boolean isUseFuzzyMatching() {
        return this.useFuzzyMatching;
    }

    public AutocompleteRequest setUseFuzzyMatching(Boolean useFuzzyMatching) {
        this.useFuzzyMatching = useFuzzyMatching;
        return this;
    }

    public String getHighlightPostTag() {
        return this.highlightPostTag;
    }

    public AutocompleteRequest setHighlightPostTag(String highlightPostTag) {
        this.highlightPostTag = highlightPostTag;
        return this;
    }

    public String getHighlightPreTag() {
        return this.highlightPreTag;
    }

    public AutocompleteRequest setHighlightPreTag(String highlightPreTag) {
        this.highlightPreTag = highlightPreTag;
        return this;
    }

    public Double getMinimumCoverage() {
        return this.minimumCoverage;
    }

    public AutocompleteRequest setMinimumCoverage(Double minimumCoverage) {
        this.minimumCoverage = minimumCoverage;
        return this;
    }

    public String getSearchFields() {
        return this.searchFields;
    }

    public AutocompleteRequest setSearchFields(String searchFields) {
        this.searchFields = searchFields;
        return this;
    }

    public String getSuggesterName() {
        return this.suggesterName;
    }

    public Integer getTop() {
        return this.top;
    }

    public AutocompleteRequest setTop(Integer top) {
        this.top = top;
        return this;
    }

    public void validate() {
        if (this.getSearchText() == null) {
            throw new IllegalArgumentException("Missing required property searchText in model AutocompleteRequest");
        }
        if (this.getSuggesterName() == null) {
            throw new IllegalArgumentException("Missing required property suggesterName in model AutocompleteRequest");
        }
    }
}

