/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.search.documents.indexes.models.WordDelimiterTokenFilter;
import java.util.ArrayList;

public final class WordDelimiterTokenFilterConverter {
    public static WordDelimiterTokenFilter map(com.azure.search.documents.indexes.implementation.models.WordDelimiterTokenFilter obj) {
        if (obj == null) {
            return null;
        }
        WordDelimiterTokenFilter wordDelimiterTokenFilter = new WordDelimiterTokenFilter(obj.getName());
        Boolean catenateNumbers = obj.isCatenateNumbers();
        wordDelimiterTokenFilter.setNumbersCatenated(catenateNumbers);
        if (obj.getProtectedWords() != null) {
            wordDelimiterTokenFilter.setProtectedWords(obj.getProtectedWords());
        }
        Boolean generateNumberParts = obj.isGenerateNumberParts();
        wordDelimiterTokenFilter.setGenerateNumberParts(generateNumberParts);
        Boolean stemEnglishPossessive = obj.isStemEnglishPossessive();
        wordDelimiterTokenFilter.setStemEnglishPossessive(stemEnglishPossessive);
        Boolean splitOnCaseChange = obj.isSplitOnCaseChange();
        wordDelimiterTokenFilter.setSplitOnCaseChange(splitOnCaseChange);
        Boolean generateWordParts = obj.isGenerateWordParts();
        wordDelimiterTokenFilter.setGenerateWordParts(generateWordParts);
        Boolean splitOnNumerics = obj.isSplitOnNumerics();
        wordDelimiterTokenFilter.setSplitOnNumerics(splitOnNumerics);
        Boolean preserveOriginal = obj.isPreserveOriginal();
        wordDelimiterTokenFilter.setPreserveOriginal(preserveOriginal);
        Boolean catenateAll = obj.isCatenateAll();
        wordDelimiterTokenFilter.setCatenateAll(catenateAll);
        Boolean catenateWords = obj.isCatenateWords();
        wordDelimiterTokenFilter.setWordsCatenated(catenateWords);
        return wordDelimiterTokenFilter;
    }

    public static com.azure.search.documents.indexes.implementation.models.WordDelimiterTokenFilter map(WordDelimiterTokenFilter obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.indexes.implementation.models.WordDelimiterTokenFilter wordDelimiterTokenFilter = new com.azure.search.documents.indexes.implementation.models.WordDelimiterTokenFilter(obj.getName());
        Boolean catenateNumbers = obj.areNumbersCatenated();
        wordDelimiterTokenFilter.setCatenateNumbers(catenateNumbers);
        if (obj.getProtectedWords() != null) {
            ArrayList<String> protectedWords = new ArrayList<String>(obj.getProtectedWords());
            wordDelimiterTokenFilter.setProtectedWords(protectedWords);
        }
        Boolean generateNumberParts = obj.generateNumberParts();
        wordDelimiterTokenFilter.setGenerateNumberParts(generateNumberParts);
        Boolean stemEnglishPossessive = obj.isStemEnglishPossessive();
        wordDelimiterTokenFilter.setStemEnglishPossessive(stemEnglishPossessive);
        Boolean splitOnCaseChange = obj.splitOnCaseChange();
        wordDelimiterTokenFilter.setSplitOnCaseChange(splitOnCaseChange);
        Boolean generateWordParts = obj.generateWordParts();
        wordDelimiterTokenFilter.setGenerateWordParts(generateWordParts);
        Boolean splitOnNumerics = obj.splitOnNumerics();
        wordDelimiterTokenFilter.setSplitOnNumerics(splitOnNumerics);
        Boolean preserveOriginal = obj.isPreserveOriginal();
        wordDelimiterTokenFilter.setPreserveOriginal(preserveOriginal);
        Boolean catenateAll = obj.catenateAll();
        wordDelimiterTokenFilter.setCatenateAll(catenateAll);
        Boolean catenateWords = obj.areWordsCatenated();
        wordDelimiterTokenFilter.setCatenateWords(catenateWords);
        wordDelimiterTokenFilter.validate();
        return wordDelimiterTokenFilter;
    }

    private WordDelimiterTokenFilterConverter() {
    }
}

