/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.search.documents.implementation.converters.SearchResourceEncryptionKeyConverter;
import com.azure.search.documents.indexes.implementation.models.SearchResourceEncryptionKey;
import com.azure.search.documents.indexes.models.SynonymMap;
import java.util.Objects;

public final class SynonymMapConverter {
    public static SynonymMap map(com.azure.search.documents.indexes.implementation.models.SynonymMap obj) {
        if (obj == null) {
            return null;
        }
        SynonymMap synonymMap = new SynonymMap(obj.getName(), obj.getSynonyms());
        String eTag = obj.getETag();
        synonymMap.setETag(eTag);
        if (obj.getEncryptionKey() != null) {
            com.azure.search.documents.indexes.models.SearchResourceEncryptionKey encryptionKey = SearchResourceEncryptionKeyConverter.map(obj.getEncryptionKey());
            synonymMap.setEncryptionKey(encryptionKey);
        }
        return synonymMap;
    }

    public static com.azure.search.documents.indexes.implementation.models.SynonymMap map(SynonymMap obj) {
        if (obj == null) {
            return null;
        }
        Objects.requireNonNull(obj.getName(), "SynonymMap name cannot be null.");
        com.azure.search.documents.indexes.implementation.models.SynonymMap synonymMap = new com.azure.search.documents.indexes.implementation.models.SynonymMap(obj.getName(), "solr", obj.getSynonyms());
        String eTag = obj.getETag();
        synonymMap.setETag(eTag);
        if (obj.getEncryptionKey() != null) {
            SearchResourceEncryptionKey encryptionKey = SearchResourceEncryptionKeyConverter.map(obj.getEncryptionKey());
            synonymMap.setEncryptionKey(encryptionKey);
        }
        return synonymMap;
    }

    private SynonymMapConverter() {
    }
}

