/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.core.util.logging.ClientLogger;
import com.azure.search.documents.implementation.converters.BM25SimilarityConverter;
import com.azure.search.documents.implementation.converters.ClassicSimilarityConverter;
import com.azure.search.documents.indexes.implementation.models.BM25Similarity;
import com.azure.search.documents.indexes.implementation.models.ClassicSimilarity;
import com.azure.search.documents.indexes.implementation.models.Similarity;
import com.azure.search.documents.indexes.models.BM25SimilarityAlgorithm;
import com.azure.search.documents.indexes.models.ClassicSimilarityAlgorithm;
import com.azure.search.documents.indexes.models.SimilarityAlgorithm;

public final class SimilarityConverter {
    private static final ClientLogger LOGGER = new ClientLogger(SimilarityConverter.class);

    public static SimilarityAlgorithm map(Similarity obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ClassicSimilarity) {
            return ClassicSimilarityConverter.map((ClassicSimilarity)obj);
        }
        if (obj instanceof BM25Similarity) {
            return BM25SimilarityConverter.map((BM25Similarity)obj);
        }
        throw LOGGER.logExceptionAsError(new RuntimeException(String.format("The subclass does not exist in external used model %s.", obj.getClass().getSimpleName())));
    }

    public static Similarity map(SimilarityAlgorithm obj) {
        if (obj instanceof ClassicSimilarityAlgorithm) {
            return ClassicSimilarityConverter.map((ClassicSimilarityAlgorithm)obj);
        }
        if (obj instanceof BM25SimilarityAlgorithm) {
            return BM25SimilarityConverter.map((BM25SimilarityAlgorithm)obj);
        }
        throw LOGGER.logExceptionAsError(new RuntimeException(String.format("The subclass does not exist in internal used model %s.", obj.getClass().getSimpleName())));
    }

    private SimilarityConverter() {
    }
}

