/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.search.documents.implementation.converters.ResourceCounterConverter;
import com.azure.search.documents.indexes.implementation.models.ResourceCounter;
import com.azure.search.documents.indexes.implementation.models.ServiceCounters;
import com.azure.search.documents.indexes.models.SearchServiceCounters;
import com.fasterxml.jackson.databind.ObjectMapper;

public final class ServiceCountersConverter {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static SearchServiceCounters map(ServiceCounters obj) {
        return (SearchServiceCounters)OBJECT_MAPPER.convertValue((Object)obj, SearchServiceCounters.class);
    }

    public static ServiceCounters map(SearchServiceCounters obj) {
        if (obj == null) {
            return null;
        }
        ResourceCounter documentCounter = obj.getDocumentCounter() == null ? null : ResourceCounterConverter.map(obj.getDocumentCounter());
        ResourceCounter indexCounter = obj.getDocumentCounter() == null ? null : ResourceCounterConverter.map(obj.getIndexCounter());
        ResourceCounter synonymMapCounter = obj.getDocumentCounter() == null ? null : ResourceCounterConverter.map(obj.getSynonymMapCounter());
        ResourceCounter storageSizeCounter = obj.getDocumentCounter() == null ? null : ResourceCounterConverter.map(obj.getStorageSizeCounter());
        ResourceCounter dataSourceCounter = obj.getDocumentCounter() == null ? null : ResourceCounterConverter.map(obj.getDataSourceCounter());
        ResourceCounter indexerCounter = obj.getDocumentCounter() == null ? null : ResourceCounterConverter.map(obj.getIndexerCounter());
        ServiceCounters serviceCounters = new ServiceCounters(documentCounter, indexCounter, indexerCounter, dataSourceCounter, storageSizeCounter, synonymMapCounter);
        serviceCounters.validate();
        return serviceCounters;
    }

    private ServiceCountersConverter() {
    }
}

