/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.core.util.logging.ClientLogger;
import com.azure.search.documents.implementation.converters.LexicalAnalyzerNameConverter;
import com.azure.search.documents.implementation.converters.SearchFieldDataTypeConverter;
import com.azure.search.documents.indexes.implementation.models.LexicalAnalyzerName;
import com.azure.search.documents.indexes.implementation.models.SearchField;
import com.azure.search.documents.indexes.models.SearchFieldDataType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class SearchFieldConverter {
    private static final ClientLogger LOGGER = new ClientLogger(SearchFieldConverter.class);

    public static com.azure.search.documents.indexes.models.SearchField map(SearchField obj) {
        if (obj == null) {
            return null;
        }
        SearchFieldDataType type = obj.getType() == null ? null : SearchFieldDataTypeConverter.map(obj.getType());
        com.azure.search.documents.indexes.models.SearchField searchField = new com.azure.search.documents.indexes.models.SearchField(obj.getName(), type);
        Boolean filterable = obj.isFilterable();
        searchField.setFilterable(filterable);
        Boolean hidden = obj.isRetrievable() == null ? null : Boolean.valueOf(obj.isRetrievable() == false);
        searchField.setHidden(hidden);
        Boolean sortable = obj.isSortable();
        searchField.setSortable(sortable);
        Boolean searchable = obj.isSearchable();
        searchField.setSearchable(searchable);
        if (obj.getAnalyzer() != null) {
            com.azure.search.documents.indexes.models.LexicalAnalyzerName analyzer = LexicalAnalyzerNameConverter.map(obj.getAnalyzer());
            searchField.setAnalyzerName(analyzer);
        }
        if (obj.getSearchAnalyzer() != null) {
            com.azure.search.documents.indexes.models.LexicalAnalyzerName searchAnalyzer = LexicalAnalyzerNameConverter.map(obj.getSearchAnalyzer());
            searchField.setSearchAnalyzerName(searchAnalyzer);
        }
        if (obj.getIndexAnalyzer() != null) {
            com.azure.search.documents.indexes.models.LexicalAnalyzerName indexAnalyzer = LexicalAnalyzerNameConverter.map(obj.getIndexAnalyzer());
            searchField.setIndexAnalyzerName(indexAnalyzer);
        }
        Boolean facetable = obj.isFacetable();
        searchField.setFacetable(facetable);
        if (obj.getSynonymMaps() != null) {
            ArrayList<String> synonymMaps = new ArrayList<String>(obj.getSynonymMaps());
            searchField.setSynonymMapNames(synonymMaps);
        }
        if (obj.getFields() != null) {
            List<com.azure.search.documents.indexes.models.SearchField> fields = obj.getFields().stream().map(SearchFieldConverter::map).collect(Collectors.toList());
            searchField.setFields(fields);
        }
        Boolean key = obj.isKey();
        searchField.setKey(key);
        return searchField;
    }

    public static SearchField map(com.azure.search.documents.indexes.models.SearchField obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.indexes.implementation.models.SearchFieldDataType type = obj.getType() == null ? null : SearchFieldDataTypeConverter.map(obj.getType());
        SearchField searchField = new SearchField(obj.getName(), type);
        Boolean filterable = obj.isFilterable();
        searchField.setFilterable(filterable);
        Boolean hidden = obj.isHidden() == null ? null : Boolean.valueOf(obj.isHidden() == false);
        searchField.setRetrievable(hidden);
        Boolean sortable = obj.isSortable();
        searchField.setSortable(sortable);
        Boolean searchable = obj.isSearchable();
        searchField.setSearchable(searchable);
        if (obj.getAnalyzerName() != null) {
            LexicalAnalyzerName analyzer = LexicalAnalyzerNameConverter.map(obj.getAnalyzerName());
            searchField.setAnalyzer(analyzer);
        }
        if (obj.getSearchAnalyzerName() != null) {
            LexicalAnalyzerName searchAnalyzer = LexicalAnalyzerNameConverter.map(obj.getSearchAnalyzerName());
            searchField.setSearchAnalyzer(searchAnalyzer);
        }
        if (obj.getIndexAnalyzerName() != null) {
            LexicalAnalyzerName indexAnalyzer = LexicalAnalyzerNameConverter.map(obj.getIndexAnalyzerName());
            searchField.setIndexAnalyzer(indexAnalyzer);
        }
        Boolean facetable = obj.isFacetable();
        searchField.setFacetable(facetable);
        if (obj.getSynonymMapNames() != null) {
            ArrayList<String> synonymMaps = new ArrayList<String>(obj.getSynonymMapNames());
            searchField.setSynonymMaps(synonymMaps);
        }
        if (obj.getFields() != null) {
            List<SearchField> fields = obj.getFields().stream().map(SearchFieldConverter::map).collect(Collectors.toList());
            searchField.setFields(fields);
        }
        Boolean key = obj.isKey();
        searchField.setKey(key);
        searchField.validate();
        return searchField;
    }

    private SearchFieldConverter() {
    }
}

