/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.core.util.ExpandableStringEnum;
import com.azure.search.documents.indexes.models.PatternTokenizer;
import com.azure.search.documents.indexes.models.RegexFlags;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class PatternTokenizerConverter {
    public static PatternTokenizer map(com.azure.search.documents.indexes.implementation.models.PatternTokenizer obj) {
        if (obj == null) {
            return null;
        }
        PatternTokenizer patternTokenizer = new PatternTokenizer(obj.getName());
        String pattern = obj.getPattern();
        patternTokenizer.setPattern(pattern);
        if (obj.getFlags() != null) {
            patternTokenizer.setFlags(Arrays.stream(obj.getFlags().toString().split("\\|")).map(RegexFlags::fromString).collect(Collectors.toList()));
        }
        Integer group = obj.getGroup();
        patternTokenizer.setGroup(group);
        return patternTokenizer;
    }

    public static com.azure.search.documents.indexes.implementation.models.PatternTokenizer map(PatternTokenizer obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.indexes.implementation.models.PatternTokenizer patternTokenizer = new com.azure.search.documents.indexes.implementation.models.PatternTokenizer(obj.getName());
        String pattern = obj.getPattern();
        patternTokenizer.setPattern(pattern);
        if (obj.getFlags() != null) {
            String flattenFlags = obj.getFlags().stream().map(ExpandableStringEnum::toString).collect(Collectors.joining("|"));
            patternTokenizer.setFlags(com.azure.search.documents.indexes.implementation.models.RegexFlags.fromString(flattenFlags));
        }
        Integer group = obj.getGroup();
        patternTokenizer.setGroup(group);
        patternTokenizer.validate();
        return patternTokenizer;
    }

    private PatternTokenizerConverter() {
    }
}

