/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.core.util.ExpandableStringEnum;
import com.azure.search.documents.indexes.implementation.models.PatternAnalyzer;
import com.azure.search.documents.indexes.models.RegexFlags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class PatternAnalyzerConverter {
    public static com.azure.search.documents.indexes.models.PatternAnalyzer map(PatternAnalyzer obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.indexes.models.PatternAnalyzer patternAnalyzer = new com.azure.search.documents.indexes.models.PatternAnalyzer(obj.getName());
        Boolean lowerCaseTerms = obj.isLowerCaseTerms();
        patternAnalyzer.setLowerCaseTerms(lowerCaseTerms);
        String pattern = obj.getPattern();
        patternAnalyzer.setPattern(pattern);
        if (obj.getFlags() != null) {
            patternAnalyzer.setFlags(Arrays.stream(obj.getFlags().toString().split("\\|")).map(RegexFlags::fromString).collect(Collectors.toList()));
        }
        if (obj.getStopwords() != null) {
            patternAnalyzer.setStopwords(obj.getStopwords());
        }
        return patternAnalyzer;
    }

    public static PatternAnalyzer map(com.azure.search.documents.indexes.models.PatternAnalyzer obj) {
        if (obj == null) {
            return null;
        }
        PatternAnalyzer patternAnalyzer = new PatternAnalyzer(obj.getName());
        Boolean lowerCaseTerms = obj.areLowerCaseTerms();
        patternAnalyzer.setLowerCaseTerms(lowerCaseTerms);
        String pattern = obj.getPattern();
        patternAnalyzer.setPattern(pattern);
        if (obj.getFlags() != null) {
            String flattenFlags = obj.getFlags().stream().map(ExpandableStringEnum::toString).collect(Collectors.joining("|"));
            patternAnalyzer.setFlags(com.azure.search.documents.indexes.implementation.models.RegexFlags.fromString(flattenFlags));
        }
        if (obj.getStopwords() != null) {
            ArrayList<String> stopwords = new ArrayList<String>(obj.getStopwords());
            patternAnalyzer.setStopwords(stopwords);
        }
        patternAnalyzer.validate();
        return patternAnalyzer;
    }

    private PatternAnalyzerConverter() {
    }
}

