/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.search.documents.implementation.util.PrivateFieldAccessHelper;
import com.azure.search.documents.indexes.implementation.models.NGramTokenFilter;
import com.azure.search.documents.indexes.implementation.models.NGramTokenFilterV2;
import com.azure.search.documents.indexes.implementation.models.TokenFilter;

public final class NGramTokenFilterConverter {
    private static final String V1_ODATA_TYPE = "#Microsoft.Azure.Search.NGramTokenFilter";
    private static final String V2_ODATA_TYPE = "#Microsoft.Azure.Search.NGramTokenFilterV2";
    private static final String ODATA_FIELD_NAME = "odataType";

    public static com.azure.search.documents.indexes.models.NGramTokenFilter map(NGramTokenFilter obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.indexes.models.NGramTokenFilter nGramTokenFilter = new com.azure.search.documents.indexes.models.NGramTokenFilter(obj.getName());
        PrivateFieldAccessHelper.set(nGramTokenFilter, ODATA_FIELD_NAME, V1_ODATA_TYPE);
        Integer maxGram = obj.getMaxGram();
        nGramTokenFilter.setMaxGram(maxGram);
        Integer minGram = obj.getMinGram();
        nGramTokenFilter.setMinGram(minGram);
        return nGramTokenFilter;
    }

    public static com.azure.search.documents.indexes.models.NGramTokenFilter map(NGramTokenFilterV2 obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.indexes.models.NGramTokenFilter nGramTokenFilter = new com.azure.search.documents.indexes.models.NGramTokenFilter(obj.getName());
        PrivateFieldAccessHelper.set(nGramTokenFilter, ODATA_FIELD_NAME, V2_ODATA_TYPE);
        Integer maxGram = obj.getMaxGram();
        nGramTokenFilter.setMaxGram(maxGram);
        Integer minGram = obj.getMinGram();
        nGramTokenFilter.setMinGram(minGram);
        return nGramTokenFilter;
    }

    public static TokenFilter map(com.azure.search.documents.indexes.models.NGramTokenFilter obj) {
        if (obj == null) {
            return null;
        }
        String identifier = PrivateFieldAccessHelper.get(obj, ODATA_FIELD_NAME, String.class);
        if (V1_ODATA_TYPE.equals(identifier)) {
            NGramTokenFilter nGramTokenFilter = new NGramTokenFilter(obj.getName()).setMaxGram(obj.getMaxGram()).setMinGram(obj.getMinGram());
            nGramTokenFilter.validate();
            return nGramTokenFilter;
        }
        NGramTokenFilterV2 nGramTokenFilter = new NGramTokenFilterV2(obj.getName()).setMaxGram(obj.getMaxGram()).setMinGram(obj.getMinGram());
        nGramTokenFilter.validate();
        return nGramTokenFilter;
    }

    private NGramTokenFilterConverter() {
    }
}

