/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.search.documents.implementation.util.PrivateFieldAccessHelper;
import com.azure.search.documents.indexes.implementation.models.LexicalTokenizer;
import com.azure.search.documents.indexes.implementation.models.LuceneStandardTokenizerV2;
import com.azure.search.documents.indexes.models.LuceneStandardTokenizer;

public final class LuceneStandardTokenizerConverter {
    private static final String V1_ODATA_TYPE = "#Microsoft.Azure.Search.LuceneStandardTokenizer";
    private static final String V2_ODATA_TYPE = "#Microsoft.Azure.Search.LuceneStandardTokenizerV2";
    private static final String ODATA_FIELD_NAME = "odataType";

    public static LuceneStandardTokenizer map(com.azure.search.documents.indexes.implementation.models.LuceneStandardTokenizer obj) {
        if (obj == null) {
            return null;
        }
        LuceneStandardTokenizer luceneStandardTokenizer = new LuceneStandardTokenizer(obj.getName());
        PrivateFieldAccessHelper.set(luceneStandardTokenizer, ODATA_FIELD_NAME, V1_ODATA_TYPE);
        Integer maxTokenLength = obj.getMaxTokenLength();
        luceneStandardTokenizer.setMaxTokenLength(maxTokenLength);
        return luceneStandardTokenizer;
    }

    public static LuceneStandardTokenizer map(LuceneStandardTokenizerV2 obj) {
        if (obj == null) {
            return null;
        }
        LuceneStandardTokenizer luceneStandardTokenizer = new LuceneStandardTokenizer(obj.getName());
        PrivateFieldAccessHelper.set(luceneStandardTokenizer, ODATA_FIELD_NAME, V2_ODATA_TYPE);
        Integer maxTokenLength = obj.getMaxTokenLength();
        luceneStandardTokenizer.setMaxTokenLength(maxTokenLength);
        return luceneStandardTokenizer;
    }

    public static LexicalTokenizer map(LuceneStandardTokenizer obj) {
        if (obj == null) {
            return null;
        }
        String identifier = PrivateFieldAccessHelper.get(obj, ODATA_FIELD_NAME, String.class);
        if (V1_ODATA_TYPE.equals(identifier)) {
            return new com.azure.search.documents.indexes.implementation.models.LuceneStandardTokenizer(obj.getName()).setMaxTokenLength(obj.getMaxTokenLength());
        }
        return new LuceneStandardTokenizerV2(obj.getName()).setMaxTokenLength(obj.getMaxTokenLength());
    }

    private LuceneStandardTokenizerConverter() {
    }
}

