/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.core.util.logging.ClientLogger;
import com.azure.search.documents.implementation.converters.CustomAnalyzerConverter;
import com.azure.search.documents.implementation.converters.LuceneStandardAnalyzerConverter;
import com.azure.search.documents.implementation.converters.PatternAnalyzerConverter;
import com.azure.search.documents.implementation.converters.StopAnalyzerConverter;
import com.azure.search.documents.indexes.implementation.models.CustomAnalyzer;
import com.azure.search.documents.indexes.implementation.models.PatternAnalyzer;
import com.azure.search.documents.indexes.models.LexicalAnalyzer;
import com.azure.search.documents.indexes.models.LuceneStandardAnalyzer;
import com.azure.search.documents.indexes.models.StopAnalyzer;

public final class LexicalAnalyzerConverter {
    private static final ClientLogger LOGGER = new ClientLogger(LexicalAnalyzerConverter.class);

    public static LexicalAnalyzer map(com.azure.search.documents.indexes.implementation.models.LexicalAnalyzer obj) {
        if (obj instanceof com.azure.search.documents.indexes.implementation.models.LuceneStandardAnalyzer) {
            return LuceneStandardAnalyzerConverter.map((com.azure.search.documents.indexes.implementation.models.LuceneStandardAnalyzer)obj);
        }
        if (obj instanceof PatternAnalyzer) {
            return PatternAnalyzerConverter.map((PatternAnalyzer)obj);
        }
        if (obj instanceof CustomAnalyzer) {
            return CustomAnalyzerConverter.map((CustomAnalyzer)obj);
        }
        if (obj instanceof com.azure.search.documents.indexes.implementation.models.StopAnalyzer) {
            return StopAnalyzerConverter.map((com.azure.search.documents.indexes.implementation.models.StopAnalyzer)obj);
        }
        throw LOGGER.logExceptionAsError(new RuntimeException(String.format("The subclass does not exist in external used model %s.", obj.getClass().getSimpleName())));
    }

    public static com.azure.search.documents.indexes.implementation.models.LexicalAnalyzer map(LexicalAnalyzer obj) {
        if (obj instanceof com.azure.search.documents.indexes.models.CustomAnalyzer) {
            return CustomAnalyzerConverter.map((com.azure.search.documents.indexes.models.CustomAnalyzer)obj);
        }
        if (obj instanceof LuceneStandardAnalyzer) {
            return LuceneStandardAnalyzerConverter.map((LuceneStandardAnalyzer)obj);
        }
        if (obj instanceof com.azure.search.documents.indexes.models.PatternAnalyzer) {
            return PatternAnalyzerConverter.map((com.azure.search.documents.indexes.models.PatternAnalyzer)obj);
        }
        if (obj instanceof StopAnalyzer) {
            return StopAnalyzerConverter.map((StopAnalyzer)obj);
        }
        throw LOGGER.logExceptionAsError(new RuntimeException(String.format("The subclass does not exist in internal used model %s.", obj.getClass().getSimpleName())));
    }

    private LexicalAnalyzerConverter() {
    }
}

