/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.search.documents.implementation.converters.EntityCategoryConverter;
import com.azure.search.documents.implementation.converters.EntityRecognitionSkillLanguageConverter;
import com.azure.search.documents.implementation.converters.InputFieldMappingEntryConverter;
import com.azure.search.documents.implementation.converters.OutputFieldMappingEntryConverter;
import com.azure.search.documents.indexes.implementation.models.EntityCategory;
import com.azure.search.documents.indexes.implementation.models.EntityRecognitionSkill;
import com.azure.search.documents.indexes.implementation.models.EntityRecognitionSkillLanguage;
import com.azure.search.documents.indexes.implementation.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import java.util.List;
import java.util.stream.Collectors;

public final class EntityRecognitionSkillConverter {
    public static com.azure.search.documents.indexes.models.EntityRecognitionSkill map(EntityRecognitionSkill obj) {
        if (obj == null) {
            return null;
        }
        List<InputFieldMappingEntry> inputs = obj.getInputs() == null ? null : obj.getInputs().stream().map(InputFieldMappingEntryConverter::map).collect(Collectors.toList());
        List outputs = obj.getOutputs() == null ? null : obj.getOutputs().stream().map(OutputFieldMappingEntryConverter::map).collect(Collectors.toList());
        com.azure.search.documents.indexes.models.EntityRecognitionSkill entityRecognitionSkill = new com.azure.search.documents.indexes.models.EntityRecognitionSkill(inputs, outputs);
        String name = obj.getName();
        entityRecognitionSkill.setName(name);
        String context = obj.getContext();
        entityRecognitionSkill.setContext(context);
        String description = obj.getDescription();
        entityRecognitionSkill.setDescription(description);
        Boolean includeTypelessEntities = obj.isIncludeTypelessEntities();
        entityRecognitionSkill.setTypelessEntitiesIncluded(includeTypelessEntities);
        if (obj.getDefaultLanguageCode() != null) {
            com.azure.search.documents.indexes.models.EntityRecognitionSkillLanguage defaultLanguageCode = EntityRecognitionSkillLanguageConverter.map(obj.getDefaultLanguageCode());
            entityRecognitionSkill.setDefaultLanguageCode(defaultLanguageCode);
        }
        if (obj.getCategories() != null) {
            entityRecognitionSkill.setCategories(obj.getCategories().stream().map(EntityCategoryConverter::map).collect(Collectors.toList()));
        }
        Double minimumPrecision = obj.getMinimumPrecision();
        entityRecognitionSkill.setMinimumPrecision(minimumPrecision);
        return entityRecognitionSkill;
    }

    public static EntityRecognitionSkill map(com.azure.search.documents.indexes.models.EntityRecognitionSkill obj) {
        if (obj == null) {
            return null;
        }
        List<OutputFieldMappingEntry> outputs = obj.getOutputs() == null ? null : obj.getOutputs().stream().map(OutputFieldMappingEntryConverter::map).collect(Collectors.toList());
        List inputs = obj.getInputs() == null ? null : obj.getInputs().stream().map(InputFieldMappingEntryConverter::map).collect(Collectors.toList());
        EntityRecognitionSkill entityRecognitionSkill = new EntityRecognitionSkill(inputs, outputs);
        String name = obj.getName();
        entityRecognitionSkill.setName(name);
        String context = obj.getContext();
        entityRecognitionSkill.setContext(context);
        String description = obj.getDescription();
        entityRecognitionSkill.setDescription(description);
        Boolean includeTypelessEntities = obj.areTypelessEntitiesIncluded();
        entityRecognitionSkill.setIncludeTypelessEntities(includeTypelessEntities);
        if (obj.getDefaultLanguageCode() != null) {
            EntityRecognitionSkillLanguage defaultLanguageCode = EntityRecognitionSkillLanguageConverter.map(obj.getDefaultLanguageCode());
            entityRecognitionSkill.setDefaultLanguageCode(defaultLanguageCode);
        }
        if (obj.getCategories() != null) {
            List<EntityCategory> categories = obj.getCategories().stream().map(EntityCategoryConverter::map).collect(Collectors.toList());
            entityRecognitionSkill.setCategories(categories);
        }
        Double minimumPrecision = obj.getMinimumPrecision();
        entityRecognitionSkill.setMinimumPrecision(minimumPrecision);
        entityRecognitionSkill.validate();
        return entityRecognitionSkill;
    }

    private EntityRecognitionSkillConverter() {
    }
}

