/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.search.documents.implementation.converters.EdgeNGramTokenFilterSideConverter;
import com.azure.search.documents.implementation.util.PrivateFieldAccessHelper;
import com.azure.search.documents.indexes.implementation.models.EdgeNGramTokenFilter;
import com.azure.search.documents.indexes.implementation.models.EdgeNGramTokenFilterSide;
import com.azure.search.documents.indexes.implementation.models.EdgeNGramTokenFilterV2;
import com.azure.search.documents.indexes.implementation.models.TokenFilter;

public final class EdgeNGramTokenFilterConverter {
    private static final String V1_ODATA_TYPE = "#Microsoft.Azure.Search.EdgeNGramTokenFilter";
    private static final String V2_ODATA_TYPE = "#Microsoft.Azure.Search.EdgeNGramTokenFilterV2";
    private static final String ODATA_FIELD_NAME = "odataType";

    public static com.azure.search.documents.indexes.models.EdgeNGramTokenFilter map(EdgeNGramTokenFilter obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.indexes.models.EdgeNGramTokenFilter edgeNGramTokenFilter = new com.azure.search.documents.indexes.models.EdgeNGramTokenFilter(obj.getName());
        PrivateFieldAccessHelper.set(edgeNGramTokenFilter, ODATA_FIELD_NAME, V1_ODATA_TYPE);
        Integer maxGram = obj.getMaxGram();
        edgeNGramTokenFilter.setMaxGram(maxGram);
        if (obj.getSide() != null) {
            com.azure.search.documents.indexes.models.EdgeNGramTokenFilterSide side = EdgeNGramTokenFilterSideConverter.map(obj.getSide());
            edgeNGramTokenFilter.setSide(side);
        }
        Integer minGram = obj.getMinGram();
        edgeNGramTokenFilter.setMinGram(minGram);
        return edgeNGramTokenFilter;
    }

    public static com.azure.search.documents.indexes.models.EdgeNGramTokenFilter map(EdgeNGramTokenFilterV2 obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.indexes.models.EdgeNGramTokenFilter edgeNGramTokenFilter = new com.azure.search.documents.indexes.models.EdgeNGramTokenFilter(obj.getName());
        PrivateFieldAccessHelper.set(edgeNGramTokenFilter, ODATA_FIELD_NAME, V2_ODATA_TYPE);
        Integer maxGram = obj.getMaxGram();
        edgeNGramTokenFilter.setMaxGram(maxGram);
        if (obj.getSide() != null) {
            com.azure.search.documents.indexes.models.EdgeNGramTokenFilterSide side = EdgeNGramTokenFilterSideConverter.map(obj.getSide());
            edgeNGramTokenFilter.setSide(side);
        }
        Integer minGram = obj.getMinGram();
        edgeNGramTokenFilter.setMinGram(minGram);
        return edgeNGramTokenFilter;
    }

    public static TokenFilter map(com.azure.search.documents.indexes.models.EdgeNGramTokenFilter obj) {
        EdgeNGramTokenFilterSide side;
        if (obj == null) {
            return null;
        }
        String identifier = PrivateFieldAccessHelper.get(obj, ODATA_FIELD_NAME, String.class);
        EdgeNGramTokenFilterSide edgeNGramTokenFilterSide = side = obj.getSide() == null ? null : EdgeNGramTokenFilterSideConverter.map(obj.getSide());
        if (V1_ODATA_TYPE.equals(identifier)) {
            EdgeNGramTokenFilter edgeNGramTokenFilter = new EdgeNGramTokenFilter(obj.getName()).setSide(side).setMaxGram(obj.getMaxGram()).setMinGram(obj.getMinGram());
            edgeNGramTokenFilter.validate();
            return edgeNGramTokenFilter;
        }
        EdgeNGramTokenFilterV2 edgeNGramTokenFilter = new EdgeNGramTokenFilterV2(obj.getName()).setSide(side).setMaxGram(obj.getMaxGram()).setMinGram(obj.getMinGram());
        edgeNGramTokenFilter.validate();
        return edgeNGramTokenFilter;
    }

    private EdgeNGramTokenFilterConverter() {
    }
}

