/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.search.documents.implementation.converters.AutocompleteModeConverter;
import com.azure.search.documents.implementation.util.PrivateFieldAccessHelper;
import com.azure.search.documents.models.AutocompleteMode;
import com.azure.search.documents.models.AutocompleteOptions;
import java.util.ArrayList;

public final class AutocompleteOptionsConverter {
    public static AutocompleteOptions map(com.azure.search.documents.implementation.models.AutocompleteOptions obj) {
        if (obj == null) {
            return null;
        }
        AutocompleteOptions autocompleteOptions = new AutocompleteOptions();
        String filter = obj.getFilter();
        autocompleteOptions.setFilter(filter);
        Boolean useFuzzyMatching = obj.isUseFuzzyMatching();
        autocompleteOptions.setUseFuzzyMatching(useFuzzyMatching);
        Double minimumCoverage = obj.getMinimumCoverage();
        autocompleteOptions.setMinimumCoverage(minimumCoverage);
        if (obj.getAutocompleteMode() != null) {
            AutocompleteMode autocompleteMode = AutocompleteModeConverter.map(obj.getAutocompleteMode());
            autocompleteOptions.setAutocompleteMode(autocompleteMode);
        }
        Integer top = obj.getTop();
        autocompleteOptions.setTop(top);
        String highlightPostTag = obj.getHighlightPostTag();
        autocompleteOptions.setHighlightPostTag(highlightPostTag);
        if (obj.getSearchFields() != null) {
            ArrayList<String> searchFields = new ArrayList<String>(obj.getSearchFields());
            PrivateFieldAccessHelper.set(autocompleteOptions, "searchFields", searchFields);
        }
        String highlightPreTag = obj.getHighlightPreTag();
        autocompleteOptions.setHighlightPreTag(highlightPreTag);
        return autocompleteOptions;
    }

    public static com.azure.search.documents.implementation.models.AutocompleteOptions map(AutocompleteOptions obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.implementation.models.AutocompleteOptions autocompleteOptions = new com.azure.search.documents.implementation.models.AutocompleteOptions();
        String filter = obj.getFilter();
        autocompleteOptions.setFilter(filter);
        Boolean useFuzzyMatching = obj.useFuzzyMatching();
        autocompleteOptions.setUseFuzzyMatching(useFuzzyMatching);
        Double minimumCoverage = obj.getMinimumCoverage();
        autocompleteOptions.setMinimumCoverage(minimumCoverage);
        if (obj.getAutocompleteMode() != null) {
            com.azure.search.documents.implementation.models.AutocompleteMode autocompleteMode = AutocompleteModeConverter.map(obj.getAutocompleteMode());
            autocompleteOptions.setAutocompleteMode(autocompleteMode);
        }
        Integer top = obj.getTop();
        autocompleteOptions.setTop(top);
        String highlightPostTag = obj.getHighlightPostTag();
        autocompleteOptions.setHighlightPostTag(highlightPostTag);
        if (obj.getSearchFields() != null) {
            ArrayList<String> searchFields = new ArrayList<String>(obj.getSearchFields());
            PrivateFieldAccessHelper.set(autocompleteOptions, "searchFields", searchFields);
        }
        String highlightPreTag = obj.getHighlightPreTag();
        autocompleteOptions.setHighlightPreTag(highlightPreTag);
        return autocompleteOptions;
    }

    private AutocompleteOptionsConverter() {
    }
}

