/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.implementation.DocumentsImpl;

public final class SearchIndexClientImpl {
    private final String endpoint;
    private final String indexName;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final DocumentsImpl documents;

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public DocumentsImpl getDocuments() {
        return this.documents;
    }

    SearchIndexClientImpl(String endpoint, String indexName) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, indexName);
    }

    SearchIndexClientImpl(HttpPipeline httpPipeline, String endpoint, String indexName) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, indexName);
    }

    SearchIndexClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String indexName) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.indexName = indexName;
        this.apiVersion = "2020-06-30";
        this.documents = new DocumentsImpl(this);
    }
}

