/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.implementation.SearchIndexClientImpl;
import com.azure.search.documents.implementation.models.AutocompleteMode;
import com.azure.search.documents.implementation.models.AutocompleteOptions;
import com.azure.search.documents.implementation.models.AutocompleteRequest;
import com.azure.search.documents.implementation.models.AutocompleteResult;
import com.azure.search.documents.implementation.models.IndexBatch;
import com.azure.search.documents.implementation.models.IndexDocumentsResult;
import com.azure.search.documents.implementation.models.QueryType;
import com.azure.search.documents.implementation.models.RequestOptions;
import com.azure.search.documents.implementation.models.SearchDocumentsResult;
import com.azure.search.documents.implementation.models.SearchErrorException;
import com.azure.search.documents.implementation.models.SearchMode;
import com.azure.search.documents.implementation.models.SearchOptions;
import com.azure.search.documents.implementation.models.SearchRequest;
import com.azure.search.documents.implementation.models.SuggestDocumentsResult;
import com.azure.search.documents.implementation.models.SuggestOptions;
import com.azure.search.documents.implementation.models.SuggestRequest;
import java.util.List;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class DocumentsImpl {
    private final DocumentsService service;
    private final SearchIndexClientImpl client;

    DocumentsImpl(SearchIndexClientImpl client) {
        this.service = (DocumentsService)RestProxy.create(DocumentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public Mono<Response<Long>> countWithResponseAsync(RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getIndexName() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getIndexName() is required and cannot be null."));
        }
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.count(this.client.getEndpoint(), this.client.getIndexName(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=none", context);
    }

    public Mono<Response<SearchDocumentsResult>> searchGetWithResponseAsync(String searchText, SearchOptions searchOptions, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getIndexName() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getIndexName() is required and cannot be null."));
        }
        if (searchOptions != null) {
            searchOptions.validate();
        }
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=none";
        Boolean includeTotalResultCountInternal = null;
        if (searchOptions != null) {
            includeTotalResultCountInternal = searchOptions.isIncludeTotalResultCount();
        }
        Boolean includeTotalResultCount = includeTotalResultCountInternal;
        List<String> facetsInternal = null;
        if (searchOptions != null) {
            facetsInternal = searchOptions.getFacets();
        }
        List<String> facets = facetsInternal;
        String filterInternal = null;
        if (searchOptions != null) {
            filterInternal = searchOptions.getFilter();
        }
        String filter = filterInternal;
        List<String> highlightFieldsInternal = null;
        if (searchOptions != null) {
            highlightFieldsInternal = searchOptions.getHighlightFields();
        }
        List<String> highlightFields = highlightFieldsInternal;
        String highlightPostTagInternal = null;
        if (searchOptions != null) {
            highlightPostTagInternal = searchOptions.getHighlightPostTag();
        }
        String highlightPostTag = highlightPostTagInternal;
        String highlightPreTagInternal = null;
        if (searchOptions != null) {
            highlightPreTagInternal = searchOptions.getHighlightPreTag();
        }
        String highlightPreTag = highlightPreTagInternal;
        Double minimumCoverageInternal = null;
        if (searchOptions != null) {
            minimumCoverageInternal = searchOptions.getMinimumCoverage();
        }
        Double minimumCoverage = minimumCoverageInternal;
        List<String> orderByInternal = null;
        if (searchOptions != null) {
            orderByInternal = searchOptions.getOrderBy();
        }
        List<String> orderBy = orderByInternal;
        QueryType queryTypeInternal = null;
        if (searchOptions != null) {
            queryTypeInternal = searchOptions.getQueryType();
        }
        QueryType queryType = queryTypeInternal;
        List<String> scoringParametersInternal = null;
        if (searchOptions != null) {
            scoringParametersInternal = searchOptions.getScoringParameters();
        }
        List<String> scoringParameters = scoringParametersInternal;
        String scoringProfileInternal = null;
        if (searchOptions != null) {
            scoringProfileInternal = searchOptions.getScoringProfile();
        }
        String scoringProfile = scoringProfileInternal;
        List<String> searchFieldsInternal = null;
        if (searchOptions != null) {
            searchFieldsInternal = searchOptions.getSearchFields();
        }
        List<String> searchFields = searchFieldsInternal;
        SearchMode searchModeInternal = null;
        if (searchOptions != null) {
            searchModeInternal = searchOptions.getSearchMode();
        }
        SearchMode searchMode = searchModeInternal;
        List<String> selectInternal = null;
        if (searchOptions != null) {
            selectInternal = searchOptions.getSelect();
        }
        List<String> select = selectInternal;
        Integer skipInternal = null;
        if (searchOptions != null) {
            skipInternal = searchOptions.getSkip();
        }
        Integer skip = skipInternal;
        Integer topInternal = null;
        if (searchOptions != null) {
            topInternal = searchOptions.getTop();
        }
        Integer top = topInternal;
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        String facetsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(facets, CollectionFormat.CSV);
        String highlightFieldsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(highlightFields, CollectionFormat.CSV);
        String orderByConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderBy, CollectionFormat.CSV);
        String scoringParametersConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(scoringParameters, CollectionFormat.CSV);
        String searchFieldsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(searchFields, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        return this.service.searchGet(this.client.getEndpoint(), this.client.getIndexName(), searchText, includeTotalResultCount, facetsConverted, filter, highlightFieldsConverted, highlightPostTag, highlightPreTag, minimumCoverage, orderByConverted, queryType, scoringParametersConverted, scoringProfile, searchFieldsConverted, searchMode, selectConverted, skip, top, this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", context);
    }

    public Mono<Response<SearchDocumentsResult>> searchPostWithResponseAsync(SearchRequest searchRequest, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getIndexName() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getIndexName() is required and cannot be null."));
        }
        if (searchRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchRequest is required and cannot be null."));
        }
        searchRequest.validate();
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.searchPost(this.client.getEndpoint(), this.client.getIndexName(), this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", searchRequest, context);
    }

    public Mono<Response<Object>> getWithResponseAsync(String key, List<String> selectedFields, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getIndexName() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getIndexName() is required and cannot be null."));
        }
        if (key == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter key is required and cannot be null."));
        }
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        String selectedFieldsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(selectedFields, CollectionFormat.CSV);
        return this.service.get(this.client.getEndpoint(), this.client.getIndexName(), key, selectedFieldsConverted, this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", context);
    }

    public Mono<Response<SuggestDocumentsResult>> suggestGetWithResponseAsync(String searchText, String suggesterName, SuggestOptions suggestOptions, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getIndexName() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getIndexName() is required and cannot be null."));
        }
        if (searchText == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchText is required and cannot be null."));
        }
        if (suggesterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter suggesterName is required and cannot be null."));
        }
        if (suggestOptions != null) {
            suggestOptions.validate();
        }
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=none";
        String filterInternal = null;
        if (suggestOptions != null) {
            filterInternal = suggestOptions.getFilter();
        }
        String filter = filterInternal;
        Boolean useFuzzyMatchingInternal = null;
        if (suggestOptions != null) {
            useFuzzyMatchingInternal = suggestOptions.isUseFuzzyMatching();
        }
        Boolean useFuzzyMatching = useFuzzyMatchingInternal;
        String highlightPostTagInternal = null;
        if (suggestOptions != null) {
            highlightPostTagInternal = suggestOptions.getHighlightPostTag();
        }
        String highlightPostTag = highlightPostTagInternal;
        String highlightPreTagInternal = null;
        if (suggestOptions != null) {
            highlightPreTagInternal = suggestOptions.getHighlightPreTag();
        }
        String highlightPreTag = highlightPreTagInternal;
        Double minimumCoverageInternal = null;
        if (suggestOptions != null) {
            minimumCoverageInternal = suggestOptions.getMinimumCoverage();
        }
        Double minimumCoverage = minimumCoverageInternal;
        List<String> orderByInternal = null;
        if (suggestOptions != null) {
            orderByInternal = suggestOptions.getOrderBy();
        }
        List<String> orderBy = orderByInternal;
        List<String> searchFieldsInternal = null;
        if (suggestOptions != null) {
            searchFieldsInternal = suggestOptions.getSearchFields();
        }
        List<String> searchFields = searchFieldsInternal;
        List<String> selectInternal = null;
        if (suggestOptions != null) {
            selectInternal = suggestOptions.getSelect();
        }
        List<String> select = selectInternal;
        Integer topInternal = null;
        if (suggestOptions != null) {
            topInternal = suggestOptions.getTop();
        }
        Integer top = topInternal;
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        String orderByConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderBy, CollectionFormat.CSV);
        String searchFieldsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(searchFields, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        return this.service.suggestGet(this.client.getEndpoint(), this.client.getIndexName(), searchText, suggesterName, filter, useFuzzyMatching, highlightPostTag, highlightPreTag, minimumCoverage, orderByConverted, searchFieldsConverted, selectConverted, top, this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", context);
    }

    public Mono<Response<SuggestDocumentsResult>> suggestPostWithResponseAsync(SuggestRequest suggestRequest, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getIndexName() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getIndexName() is required and cannot be null."));
        }
        if (suggestRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter suggestRequest is required and cannot be null."));
        }
        suggestRequest.validate();
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.suggestPost(this.client.getEndpoint(), this.client.getIndexName(), this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", suggestRequest, context);
    }

    public Mono<Response<IndexDocumentsResult>> indexWithResponseAsync(IndexBatch batch, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getIndexName() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getIndexName() is required and cannot be null."));
        }
        if (batch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter batch is required and cannot be null."));
        }
        batch.validate();
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.index(this.client.getEndpoint(), this.client.getIndexName(), this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", batch, context);
    }

    public Mono<Response<AutocompleteResult>> autocompleteGetWithResponseAsync(String searchText, String suggesterName, RequestOptions requestOptions, AutocompleteOptions autocompleteOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getIndexName() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getIndexName() is required and cannot be null."));
        }
        if (searchText == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchText is required and cannot be null."));
        }
        if (suggesterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter suggesterName is required and cannot be null."));
        }
        if (autocompleteOptions != null) {
            autocompleteOptions.validate();
        }
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        AutocompleteMode autocompleteModeInternal = null;
        if (autocompleteOptions != null) {
            autocompleteModeInternal = autocompleteOptions.getAutocompleteMode();
        }
        AutocompleteMode autocompleteMode = autocompleteModeInternal;
        String filterInternal = null;
        if (autocompleteOptions != null) {
            filterInternal = autocompleteOptions.getFilter();
        }
        String filter = filterInternal;
        Boolean useFuzzyMatchingInternal = null;
        if (autocompleteOptions != null) {
            useFuzzyMatchingInternal = autocompleteOptions.isUseFuzzyMatching();
        }
        Boolean useFuzzyMatching = useFuzzyMatchingInternal;
        String highlightPostTagInternal = null;
        if (autocompleteOptions != null) {
            highlightPostTagInternal = autocompleteOptions.getHighlightPostTag();
        }
        String highlightPostTag = highlightPostTagInternal;
        String highlightPreTagInternal = null;
        if (autocompleteOptions != null) {
            highlightPreTagInternal = autocompleteOptions.getHighlightPreTag();
        }
        String highlightPreTag = highlightPreTagInternal;
        Double minimumCoverageInternal = null;
        if (autocompleteOptions != null) {
            minimumCoverageInternal = autocompleteOptions.getMinimumCoverage();
        }
        Double minimumCoverage = minimumCoverageInternal;
        List<String> searchFieldsInternal = null;
        if (autocompleteOptions != null) {
            searchFieldsInternal = autocompleteOptions.getSearchFields();
        }
        List<String> searchFields = searchFieldsInternal;
        Integer topInternal = null;
        if (autocompleteOptions != null) {
            topInternal = autocompleteOptions.getTop();
        }
        Integer top = topInternal;
        String searchFieldsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(searchFields, CollectionFormat.CSV);
        return this.service.autocompleteGet(this.client.getEndpoint(), this.client.getIndexName(), xMsClientRequestId, this.client.getApiVersion(), searchText, suggesterName, autocompleteMode, filter, useFuzzyMatching, highlightPostTag, highlightPreTag, minimumCoverage, searchFieldsConverted, top, "application/json; odata.metadata=none", context);
    }

    public Mono<Response<AutocompleteResult>> autocompletePostWithResponseAsync(AutocompleteRequest autocompleteRequest, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getIndexName() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getIndexName() is required and cannot be null."));
        }
        if (autocompleteRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter autocompleteRequest is required and cannot be null."));
        }
        autocompleteRequest.validate();
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.autocompletePost(this.client.getEndpoint(), this.client.getIndexName(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=none", autocompleteRequest, context);
    }

    @Host(value="{endpoint}/indexes('{indexName}')")
    @ServiceInterface(name="SearchIndexClientDoc")
    private static interface DocumentsService {
        @Get(value="/docs/$count")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<Long>> count(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept") String var5, Context var6);

        @Get(value="/docs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SearchDocumentsResult>> searchGet(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @QueryParam(value="search") String var3, @QueryParam(value="$count") Boolean var4, @QueryParam(value="facet") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="highlight") String var7, @QueryParam(value="highlightPostTag") String var8, @QueryParam(value="highlightPreTag") String var9, @QueryParam(value="minimumCoverage") Double var10, @QueryParam(value="$orderby") String var11, @QueryParam(value="queryType") QueryType var12, @QueryParam(value="scoringParameter") String var13, @QueryParam(value="scoringProfile") String var14, @QueryParam(value="searchFields") String var15, @QueryParam(value="searchMode") SearchMode var16, @QueryParam(value="$select") String var17, @QueryParam(value="$skip") Integer var18, @QueryParam(value="$top") Integer var19, @QueryParam(value="api-version") String var20, @HeaderParam(value="x-ms-client-request-id") UUID var21, @HeaderParam(value="accept") String var22, Context var23);

        @Post(value="/docs/search.post.search")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SearchDocumentsResult>> searchPost(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @HeaderParam(value="accept") String var5, @BodyParam(value="application/json") SearchRequest var6, Context var7);

        @Get(value="/docs('{key}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<Object>> get(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @PathParam(value="key") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="x-ms-client-request-id") UUID var6, @HeaderParam(value="accept") String var7, Context var8);

        @Get(value="/docs/search.suggest")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SuggestDocumentsResult>> suggestGet(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @QueryParam(value="search") String var3, @QueryParam(value="suggesterName") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="fuzzy") Boolean var6, @QueryParam(value="highlightPostTag") String var7, @QueryParam(value="highlightPreTag") String var8, @QueryParam(value="minimumCoverage") Double var9, @QueryParam(value="$orderby") String var10, @QueryParam(value="searchFields") String var11, @QueryParam(value="$select") String var12, @QueryParam(value="$top") Integer var13, @QueryParam(value="api-version") String var14, @HeaderParam(value="x-ms-client-request-id") UUID var15, @HeaderParam(value="accept") String var16, Context var17);

        @Post(value="/docs/search.post.suggest")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SuggestDocumentsResult>> suggestPost(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @HeaderParam(value="accept") String var5, @BodyParam(value="application/json") SuggestRequest var6, Context var7);

        @Post(value="/docs/search.index")
        @ExpectedResponses(value={200, 207})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<IndexDocumentsResult>> index(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @HeaderParam(value="accept") String var5, @BodyParam(value="application/json") IndexBatch var6, Context var7);

        @Get(value="/docs/search.autocomplete")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<AutocompleteResult>> autocompleteGet(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @QueryParam(value="search") String var5, @QueryParam(value="suggesterName") String var6, @QueryParam(value="autocompleteMode") AutocompleteMode var7, @QueryParam(value="$filter") String var8, @QueryParam(value="fuzzy") Boolean var9, @QueryParam(value="highlightPostTag") String var10, @QueryParam(value="highlightPreTag") String var11, @QueryParam(value="minimumCoverage") Double var12, @QueryParam(value="searchFields") String var13, @QueryParam(value="$top") Integer var14, @HeaderParam(value="accept") String var15, Context var16);

        @Post(value="/docs/search.post.autocomplete")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<AutocompleteResult>> autocompletePost(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept") String var5, @BodyParam(value="application/json") AutocompleteRequest var6, Context var7);
    }
}

