/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.search.documents.SearchAsyncClient;
import com.azure.search.documents.indexes.models.IndexDocumentsBatch;
import com.azure.search.documents.models.AutocompleteOptions;
import com.azure.search.documents.models.IndexDocumentsOptions;
import com.azure.search.documents.models.IndexDocumentsResult;
import com.azure.search.documents.models.SearchOptions;
import com.azure.search.documents.models.SuggestOptions;
import com.azure.search.documents.util.AutocompletePagedIterable;
import com.azure.search.documents.util.SearchPagedIterable;
import com.azure.search.documents.util.SuggestPagedIterable;
import java.util.List;

public final class SearchClient {
    private final SearchAsyncClient asyncClient;

    SearchClient(SearchAsyncClient searchAsyncClient) {
        this.asyncClient = searchAsyncClient;
    }

    public String getIndexName() {
        return this.asyncClient.getIndexName();
    }

    HttpPipeline getHttpPipeline() {
        return this.asyncClient.getHttpPipeline();
    }

    public String getEndpoint() {
        return this.asyncClient.getEndpoint();
    }

    public IndexDocumentsResult uploadDocuments(Iterable<?> documents) {
        return (IndexDocumentsResult)this.uploadDocumentsWithResponse(documents, null, Context.NONE).getValue();
    }

    public Response<IndexDocumentsResult> uploadDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return (Response)this.asyncClient.uploadDocumentsWithResponse(documents, options, context).block();
    }

    public IndexDocumentsResult mergeDocuments(Iterable<?> documents) {
        return (IndexDocumentsResult)this.mergeDocumentsWithResponse(documents, null, Context.NONE).getValue();
    }

    public Response<IndexDocumentsResult> mergeDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return (Response)this.asyncClient.mergeDocumentsWithResponse(documents, options, context).block();
    }

    public IndexDocumentsResult mergeOrUploadDocuments(Iterable<?> documents) {
        return (IndexDocumentsResult)this.mergeOrUploadDocumentsWithResponse(documents, null, Context.NONE).getValue();
    }

    public Response<IndexDocumentsResult> mergeOrUploadDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return (Response)this.asyncClient.mergeOrUploadDocumentsWithResponse(documents, options, context).block();
    }

    public IndexDocumentsResult deleteDocuments(Iterable<?> documents) {
        return (IndexDocumentsResult)this.deleteDocumentsWithResponse(documents, null, Context.NONE).getValue();
    }

    public Response<IndexDocumentsResult> deleteDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return (Response)this.asyncClient.deleteDocumentsWithResponse(documents, options, context).block();
    }

    public IndexDocumentsResult indexDocuments(IndexDocumentsBatch<?> batch) {
        return (IndexDocumentsResult)this.indexDocumentsWithResponse(batch, null, Context.NONE).getValue();
    }

    public Response<IndexDocumentsResult> indexDocumentsWithResponse(IndexDocumentsBatch<?> batch, IndexDocumentsOptions options, Context context) {
        return (Response)this.asyncClient.indexDocumentsWithResponse(batch, options, context).block();
    }

    public <T> T getDocument(String key, Class<T> modelClass) {
        return (T)this.getDocumentWithResponse(key, modelClass, null, Context.NONE).getValue();
    }

    public <T> Response<T> getDocumentWithResponse(String key, Class<T> modelClass, List<String> selectedFields, Context context) {
        return (Response)this.asyncClient.getDocumentWithResponse(key, modelClass, selectedFields, context).block();
    }

    public long getDocumentCount() {
        return (Long)this.getDocumentCountWithResponse(Context.NONE).getValue();
    }

    public Response<Long> getDocumentCountWithResponse(Context context) {
        return (Response)this.asyncClient.getDocumentCountWithResponse(context).block();
    }

    public SearchPagedIterable search(String searchText) {
        return this.search(searchText, null, Context.NONE);
    }

    public SearchPagedIterable search(String searchText, SearchOptions searchOptions, Context context) {
        return new SearchPagedIterable(this.asyncClient.search(searchText, searchOptions, context));
    }

    public SuggestPagedIterable suggest(String searchText, String suggesterName) {
        return this.suggest(searchText, suggesterName, null, Context.NONE);
    }

    public SuggestPagedIterable suggest(String searchText, String suggesterName, SuggestOptions suggestOptions, Context context) {
        return new SuggestPagedIterable(this.asyncClient.suggest(searchText, suggesterName, suggestOptions, context));
    }

    public AutocompletePagedIterable autocomplete(String searchText, String suggesterName) {
        return this.autocomplete(searchText, suggesterName, null, Context.NONE);
    }

    public AutocompletePagedIterable autocomplete(String searchText, String suggesterName, AutocompleteOptions autocompleteOptions, Context context) {
        return new AutocompletePagedIterable(this.asyncClient.autocomplete(searchText, suggesterName, autocompleteOptions, context));
    }
}

