// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The StemmerTokenFilter model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@odata\\.type")
@JsonTypeName("#Microsoft.Azure.Search.StemmerTokenFilter")
@JsonFlatten
@Fluent
public class StemmerTokenFilter extends TokenFilter {
    /*
     * The language to use.
     */
    @JsonProperty(value = "language", required = true)
    private StemmerTokenFilterLanguage language;

    /** Creates an instance of StemmerTokenFilter class. */
    @JsonCreator
    public StemmerTokenFilter(
            @JsonProperty(value = "name") String name,
            @JsonProperty(value = "language") StemmerTokenFilterLanguage language) {
        super(name);
        this.language = language;
    }

    /**
     * Get the language property: The language to use.
     *
     * @return the language value.
     */
    public StemmerTokenFilterLanguage getLanguage() {
        return this.language;
    }

    /**
     * Set the language property: The language to use.
     *
     * @param language the language value to set.
     * @return the StemmerTokenFilter object itself.
     */
    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (getLanguage() == null) {
            throw new IllegalArgumentException("Missing required property language in model StemmerTokenFilter");
        }
    }
}
