// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The ResourceCounter model. */
@Fluent
public final class ResourceCounter {
    /*
     * The resource usage amount.
     */
    @JsonProperty(value = "usage", required = true)
    private long usage;

    /*
     * The resource amount quota.
     */
    @JsonProperty(value = "quota")
    private Long quota;

    /** Creates an instance of ResourceCounter class. */
    @JsonCreator
    public ResourceCounter(@JsonProperty(value = "usage") long usage) {
        this.usage = usage;
    }

    /**
     * Get the usage property: The resource usage amount.
     *
     * @return the usage value.
     */
    public long getUsage() {
        return this.usage;
    }

    /**
     * Set the usage property: The resource usage amount.
     *
     * @param usage the usage value to set.
     * @return the ResourceCounter object itself.
     */
    /**
     * Get the quota property: The resource amount quota.
     *
     * @return the quota value.
     */
    public Long getQuota() {
        return this.quota;
    }

    /**
     * Set the quota property: The resource amount quota.
     *
     * @param quota the quota value to set.
     * @return the ResourceCounter object itself.
     */
    public ResourceCounter setQuota(Long quota) {
        this.quota = quota;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {}
}
