// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The PhoneticTokenFilter model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@odata\\.type")
@JsonTypeName("#Microsoft.Azure.Search.PhoneticTokenFilter")
@JsonFlatten
@Fluent
public class PhoneticTokenFilter extends TokenFilter {
    /*
     * The phonetic encoder to use. Default is "metaphone".
     */
    @JsonProperty(value = "encoder")
    private PhoneticEncoder encoder;

    /*
     * A value indicating whether encoded tokens should replace original
     * tokens. If false, encoded tokens are added as synonyms. Default is true.
     */
    @JsonProperty(value = "replace")
    private Boolean replaceOriginalTokens;

    /** Creates an instance of PhoneticTokenFilter class. */
    @JsonCreator
    public PhoneticTokenFilter(@JsonProperty(value = "name") String name) {
        super(name);
    }

    /**
     * Get the encoder property: The phonetic encoder to use. Default is "metaphone".
     *
     * @return the encoder value.
     */
    public PhoneticEncoder getEncoder() {
        return this.encoder;
    }

    /**
     * Set the encoder property: The phonetic encoder to use. Default is "metaphone".
     *
     * @param encoder the encoder value to set.
     * @return the PhoneticTokenFilter object itself.
     */
    public PhoneticTokenFilter setEncoder(PhoneticEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    /**
     * Get the replaceOriginalTokens property: A value indicating whether encoded tokens should replace original tokens.
     * If false, encoded tokens are added as synonyms. Default is true.
     *
     * @return the replaceOriginalTokens value.
     */
    public Boolean isReplaceOriginalTokens() {
        return this.replaceOriginalTokens;
    }

    /**
     * Set the replaceOriginalTokens property: A value indicating whether encoded tokens should replace original tokens.
     * If false, encoded tokens are added as synonyms. Default is true.
     *
     * @param replaceOriginalTokens the replaceOriginalTokens value to set.
     * @return the PhoneticTokenFilter object itself.
     */
    public PhoneticTokenFilter setReplaceOriginalTokens(Boolean replaceOriginalTokens) {
        this.replaceOriginalTokens = replaceOriginalTokens;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
