// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The PatternReplaceCharFilter model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@odata\\.type")
@JsonTypeName("#Microsoft.Azure.Search.PatternReplaceCharFilter")
@JsonFlatten
@Fluent
public class PatternReplaceCharFilter extends CharFilter {
    /*
     * A regular expression pattern.
     */
    @JsonProperty(value = "pattern", required = true)
    private String pattern;

    /*
     * The replacement text.
     */
    @JsonProperty(value = "replacement", required = true)
    private String replacement;

    /** Creates an instance of PatternReplaceCharFilter class. */
    @JsonCreator
    public PatternReplaceCharFilter(
            @JsonProperty(value = "name") String name,
            @JsonProperty(value = "pattern") String pattern,
            @JsonProperty(value = "replacement") String replacement) {
        super(name);
        this.pattern = pattern;
        this.replacement = replacement;
    }

    /**
     * Get the pattern property: A regular expression pattern.
     *
     * @return the pattern value.
     */
    public String getPattern() {
        return this.pattern;
    }

    /**
     * Set the pattern property: A regular expression pattern.
     *
     * @param pattern the pattern value to set.
     * @return the PatternReplaceCharFilter object itself.
     */
    /**
     * Get the replacement property: The replacement text.
     *
     * @return the replacement value.
     */
    public String getReplacement() {
        return this.replacement;
    }

    /**
     * Set the replacement property: The replacement text.
     *
     * @param replacement the replacement value to set.
     * @return the PatternReplaceCharFilter object itself.
     */
    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (getPattern() == null) {
            throw new IllegalArgumentException("Missing required property pattern in model PatternReplaceCharFilter");
        }
        if (getReplacement() == null) {
            throw new IllegalArgumentException(
                    "Missing required property replacement in model PatternReplaceCharFilter");
        }
    }
}
