// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The KeywordTokenizer model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@odata\\.type")
@JsonTypeName("#Microsoft.Azure.Search.KeywordTokenizer")
@JsonFlatten
@Fluent
public class KeywordTokenizer extends LexicalTokenizer {
    /*
     * The read buffer size in bytes. Default is 256.
     */
    @JsonProperty(value = "bufferSize")
    private Integer bufferSize;

    /** Creates an instance of KeywordTokenizer class. */
    @JsonCreator
    public KeywordTokenizer(@JsonProperty(value = "name") String name) {
        super(name);
    }

    /**
     * Get the bufferSize property: The read buffer size in bytes. Default is 256.
     *
     * @return the bufferSize value.
     */
    public Integer getBufferSize() {
        return this.bufferSize;
    }

    /**
     * Set the bufferSize property: The read buffer size in bytes. Default is 256.
     *
     * @param bufferSize the bufferSize value to set.
     * @return the KeywordTokenizer object itself.
     */
    public KeywordTokenizer setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
