// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/** The KeyPhraseExtractionSkill model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@odata\\.type")
@JsonTypeName("#Microsoft.Skills.Text.KeyPhraseExtractionSkill")
@JsonFlatten
@Fluent
public class KeyPhraseExtractionSkill extends SearchIndexerSkill {
    /*
     * A value indicating which language code to use. Default is en.
     */
    @JsonProperty(value = "defaultLanguageCode")
    private KeyPhraseExtractionSkillLanguage defaultLanguageCode;

    /*
     * A number indicating how many key phrases to return. If absent, all
     * identified key phrases will be returned.
     */
    @JsonProperty(value = "maxKeyPhraseCount")
    private Integer maxKeyPhraseCount;

    /** Creates an instance of KeyPhraseExtractionSkill class. */
    @JsonCreator
    public KeyPhraseExtractionSkill(
            @JsonProperty(value = "inputs") List<InputFieldMappingEntry> inputs,
            @JsonProperty(value = "outputs") List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    /**
     * Get the defaultLanguageCode property: A value indicating which language code to use. Default is en.
     *
     * @return the defaultLanguageCode value.
     */
    public KeyPhraseExtractionSkillLanguage getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    /**
     * Set the defaultLanguageCode property: A value indicating which language code to use. Default is en.
     *
     * @param defaultLanguageCode the defaultLanguageCode value to set.
     * @return the KeyPhraseExtractionSkill object itself.
     */
    public KeyPhraseExtractionSkill setDefaultLanguageCode(KeyPhraseExtractionSkillLanguage defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    /**
     * Get the maxKeyPhraseCount property: A number indicating how many key phrases to return. If absent, all identified
     * key phrases will be returned.
     *
     * @return the maxKeyPhraseCount value.
     */
    public Integer getMaxKeyPhraseCount() {
        return this.maxKeyPhraseCount;
    }

    /**
     * Set the maxKeyPhraseCount property: A number indicating how many key phrases to return. If absent, all identified
     * key phrases will be returned.
     *
     * @param maxKeyPhraseCount the maxKeyPhraseCount value to set.
     * @return the KeyPhraseExtractionSkill object itself.
     */
    public KeyPhraseExtractionSkill setMaxKeyPhraseCount(Integer maxKeyPhraseCount) {
        this.maxKeyPhraseCount = maxKeyPhraseCount;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
