// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/** The KeepTokenFilter model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@odata\\.type")
@JsonTypeName("#Microsoft.Azure.Search.KeepTokenFilter")
@JsonFlatten
@Fluent
public class KeepTokenFilter extends TokenFilter {
    /*
     * The list of words to keep.
     */
    @JsonProperty(value = "keepWords", required = true)
    private List<String> keepWords;

    /*
     * A value indicating whether to lower case all words first. Default is
     * false.
     */
    @JsonProperty(value = "keepWordsCase")
    private Boolean lowerCaseKeepWords;

    /** Creates an instance of KeepTokenFilter class. */
    @JsonCreator
    public KeepTokenFilter(
            @JsonProperty(value = "name") String name, @JsonProperty(value = "keepWords") List<String> keepWords) {
        super(name);
        this.keepWords = keepWords;
    }

    /**
     * Get the keepWords property: The list of words to keep.
     *
     * @return the keepWords value.
     */
    public List<String> getKeepWords() {
        return this.keepWords;
    }

    /**
     * Set the keepWords property: The list of words to keep.
     *
     * @param keepWords the keepWords value to set.
     * @return the KeepTokenFilter object itself.
     */
    /**
     * Get the lowerCaseKeepWords property: A value indicating whether to lower case all words first. Default is false.
     *
     * @return the lowerCaseKeepWords value.
     */
    public Boolean isLowerCaseKeepWords() {
        return this.lowerCaseKeepWords;
    }

    /**
     * Set the lowerCaseKeepWords property: A value indicating whether to lower case all words first. Default is false.
     *
     * @param lowerCaseKeepWords the lowerCaseKeepWords value to set.
     * @return the KeepTokenFilter object itself.
     */
    public KeepTokenFilter setLowerCaseKeepWords(Boolean lowerCaseKeepWords) {
        this.lowerCaseKeepWords = lowerCaseKeepWords;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (getKeepWords() == null) {
            throw new IllegalArgumentException("Missing required property keepWords in model KeepTokenFilter");
        }
    }
}
