// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;

/** The FreshnessScoringParameters model. */
@Fluent
public final class FreshnessScoringParameters {
    /*
     * The expiration period after which boosting will stop for a particular
     * document.
     */
    @JsonProperty(value = "boostingDuration", required = true)
    private Duration boostingDuration;

    /** Creates an instance of FreshnessScoringParameters class. */
    @JsonCreator
    public FreshnessScoringParameters(@JsonProperty(value = "boostingDuration") Duration boostingDuration) {
        this.boostingDuration = boostingDuration;
    }

    /**
     * Get the boostingDuration property: The expiration period after which boosting will stop for a particular
     * document.
     *
     * @return the boostingDuration value.
     */
    public Duration getBoostingDuration() {
        return this.boostingDuration;
    }

    /**
     * Set the boostingDuration property: The expiration period after which boosting will stop for a particular
     * document.
     *
     * @param boostingDuration the boostingDuration value to set.
     * @return the FreshnessScoringParameters object itself.
     */
    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getBoostingDuration() == null) {
            throw new IllegalArgumentException(
                    "Missing required property boostingDuration in model FreshnessScoringParameters");
        }
    }
}
