/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class WebPubSubGroupConnection
implements JsonSerializable<WebPubSubGroupConnection> {
    private final String connectionId;
    private final String userId;

    private WebPubSubGroupConnection(String connectionId, String userId) {
        this.connectionId = connectionId;
        this.userId = userId;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectionId", this.connectionId);
        if (this.userId != null) {
            jsonWriter.writeStringField("userId", this.userId);
        }
        return jsonWriter.writeEndObject();
    }

    public static WebPubSubGroupConnection fromJson(JsonReader jsonReader) throws IOException {
        return (WebPubSubGroupConnection)jsonReader.readObject(reader -> {
            String connectionId = null;
            String userId = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionId".equals(fieldName)) {
                    connectionId = reader.getString();
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    userId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (connectionId == null) {
                throw new IllegalStateException("Missing required property: connectionId");
            }
            return new WebPubSubGroupConnection(connectionId, userId);
        });
    }
}

