/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.webpubsub.WebPubSubServiceVersion;
import com.azure.messaging.webpubsub.implementation.HealthApisImpl;
import com.azure.messaging.webpubsub.implementation.WebPubSubsImpl;

public final class AzureWebPubSubServiceRestApiImpl {
    private final String endpoint;
    private final WebPubSubServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final HealthApisImpl healthApis;
    private final WebPubSubsImpl webPubSubs;

    public String getEndpoint() {
        return this.endpoint;
    }

    public WebPubSubServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public HealthApisImpl getHealthApis() {
        return this.healthApis;
    }

    public WebPubSubsImpl getWebPubSubs() {
        return this.webPubSubs;
    }

    public AzureWebPubSubServiceRestApiImpl(String endpoint, WebPubSubServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public AzureWebPubSubServiceRestApiImpl(HttpPipeline httpPipeline, String endpoint, WebPubSubServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public AzureWebPubSubServiceRestApiImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, WebPubSubServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.healthApis = new HealthApisImpl(this);
        this.webPubSubs = new WebPubSubsImpl(this);
    }
}

