/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.messaging.webpubsub.WebPubSubAuthenticationPolicy;
import com.azure.messaging.webpubsub.WebPubSubServiceClientBuilder;
import com.azure.messaging.webpubsub.WebPubSubServiceVersion;
import com.azure.messaging.webpubsub.implementation.WebPubSubUtil;
import com.azure.messaging.webpubsub.implementation.WebPubSubsImpl;
import com.azure.messaging.webpubsub.models.GetClientAccessTokenOptions;
import com.azure.messaging.webpubsub.models.WebPubSubClientAccessToken;
import com.azure.messaging.webpubsub.models.WebPubSubContentType;
import com.azure.messaging.webpubsub.models.WebPubSubPermission;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=WebPubSubServiceClientBuilder.class, isAsync=true)
public final class WebPubSubServiceAsyncClient {
    private final WebPubSubsImpl serviceClient;
    private final String hub;
    private final String endpoint;
    private final AzureKeyCredential keyCredential;
    private final WebPubSubServiceVersion version;

    WebPubSubServiceAsyncClient(WebPubSubsImpl serviceClient, String hub, String endpoint, AzureKeyCredential keyCredential, WebPubSubServiceVersion version) {
        this.serviceClient = serviceClient;
        this.hub = hub;
        this.endpoint = endpoint;
        this.keyCredential = keyCredential;
        this.version = version;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<WebPubSubClientAccessToken> getClientAccessToken(GetClientAccessTokenOptions options) {
        if (this.keyCredential == null) {
            RequestOptions requestOptions = new RequestOptions();
            if (options.getUserId() != null) {
                requestOptions.addQueryParam("userId", options.getUserId());
            }
            if (options.getExpiresAfter() != null) {
                requestOptions.addQueryParam("minutesToExpire", String.valueOf(options.getExpiresAfter().toMinutes()));
            }
            if (CoreUtils.isNullOrEmpty(options.getRoles())) {
                requestOptions.addQueryParam("role", options.getRoles().stream().collect(Collectors.joining(",")));
            }
            requestOptions.addQueryParam("api-version", this.version.getVersion());
            return this.serviceClient.generateClientTokenWithResponseAsync(this.hub, requestOptions).map(Response::getValue).map(binaryData -> {
                String token = WebPubSubUtil.getToken(binaryData);
                return WebPubSubUtil.createToken(token, this.endpoint, this.hub);
            });
        }
        return Mono.defer(() -> {
            String audience = this.endpoint + "client/hubs/" + this.hub;
            String token = WebPubSubAuthenticationPolicy.getAuthenticationToken(audience, options, this.keyCredential);
            return Mono.just((Object)WebPubSubUtil.createToken(token, this.endpoint, this.hub));
        });
    }

    Mono<Response<BinaryData>> generateClientTokenWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.generateClientTokenWithResponseAsync(this.hub, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToAllWithResponse(BinaryData message, WebPubSubContentType contentType, long contentLength, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.setHeader("Content-Type", contentType.toString());
        requestOptions.setHeader("Content-Length", String.valueOf(contentLength));
        return this.serviceClient.sendToAllWithResponseAsync(this.hub, message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToAllWithResponse(BinaryData message, RequestOptions requestOptions) {
        return this.serviceClient.sendToAllWithResponseAsync(this.hub, message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendToAll(String message, WebPubSubContentType contentType) {
        return this.sendToAllWithResponse(BinaryData.fromString((String)message), new RequestOptions().setHeader("Content-Type", contentType.toString())).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> connectionExistsWithResponse(String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.connectionExistsWithResponseAsync(this.hub, connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> closeConnectionWithResponse(String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.closeConnectionWithResponseAsync(this.hub, connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToConnectionWithResponse(String connectionId, BinaryData message, WebPubSubContentType contentType, long contentLength, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.setHeader("Content-Type", contentType.toString());
        requestOptions.setHeader("Content-Length", String.valueOf(contentLength));
        return this.serviceClient.sendToConnectionWithResponseAsync(this.hub, connectionId, message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToConnectionWithResponse(String connectionId, BinaryData message, RequestOptions requestOptions) {
        return this.serviceClient.sendToConnectionWithResponseAsync(this.hub, connectionId, message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendToConnection(String connectionId, String message, WebPubSubContentType contentType) {
        return this.sendToConnectionWithResponse(connectionId, BinaryData.fromString((String)message), new RequestOptions().setHeader("Content-Type", contentType.toString())).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> groupExistsWithResponse(String group, RequestOptions requestOptions) {
        return this.serviceClient.groupExistsWithResponseAsync(this.hub, group, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToGroupWithResponse(String group, BinaryData message, WebPubSubContentType contentType, long contentLength, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.setHeader("Content-Type", contentType.toString());
        requestOptions.setHeader("Content-Length", String.valueOf(contentLength));
        return this.serviceClient.sendToGroupWithResponseAsync(this.hub, group, message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToGroupWithResponse(String group, BinaryData message, RequestOptions requestOptions) {
        return this.serviceClient.sendToGroupWithResponseAsync(this.hub, group, message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendToGroup(String group, String message, WebPubSubContentType contentType) {
        return this.sendToGroupWithResponse(group, BinaryData.fromString((String)message), new RequestOptions().setHeader("Content-Type", contentType.toString())).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addConnectionToGroupWithResponse(String group, String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.addConnectionToGroupWithResponseAsync(this.hub, group, connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeConnectionFromGroupWithResponse(String group, String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.removeConnectionFromGroupWithResponseAsync(this.hub, group, connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> userExistsWithResponse(String userId, RequestOptions requestOptions) {
        return this.serviceClient.userExistsWithResponseAsync(this.hub, userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToUserWithResponse(String userId, BinaryData message, WebPubSubContentType contentType, long contentLength, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.setHeader("Content-Type", contentType.toString());
        requestOptions.setHeader("Content-Length", String.valueOf(contentLength));
        return this.serviceClient.sendToUserWithResponseAsync(this.hub, userId, message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToUserWithResponse(String userId, BinaryData message, RequestOptions requestOptions) {
        return this.serviceClient.sendToUserWithResponseAsync(this.hub, userId, message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendToUser(String userId, String message, WebPubSubContentType contentType) {
        return this.sendToUserWithResponse(userId, BinaryData.fromString((String)message), new RequestOptions().setHeader("Content-Type", contentType.toString())).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addUserToGroupWithResponse(String group, String userId, RequestOptions requestOptions) {
        return this.serviceClient.addUserToGroupWithResponseAsync(this.hub, group, userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeUserFromGroupWithResponse(String group, String userId, RequestOptions requestOptions) {
        return this.serviceClient.removeUserFromGroupWithResponseAsync(this.hub, group, userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeUserFromAllGroupsWithResponse(String userId, RequestOptions requestOptions) {
        return this.serviceClient.removeUserFromAllGroupsWithResponseAsync(this.hub, userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> grantPermissionWithResponse(WebPubSubPermission permission, String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.grantPermissionWithResponseAsync(this.hub, permission.toString(), connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> revokePermissionWithResponse(WebPubSubPermission permission, String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.revokePermissionWithResponseAsync(this.hub, permission.toString(), connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkPermissionWithResponse(WebPubSubPermission permission, String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.checkPermissionWithResponseAsync(this.hub, permission.toString(), connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> closeAllConnectionsWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.closeAllConnectionsWithResponseAsync(this.hub, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> closeGroupConnectionsWithResponse(String group, RequestOptions requestOptions) {
        return this.serviceClient.closeGroupConnectionsWithResponseAsync(this.hub, group, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> closeUserConnectionsWithResponse(String userId, RequestOptions requestOptions) {
        return this.serviceClient.closeUserConnectionsWithResponseAsync(this.hub, userId, requestOptions);
    }
}

