/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.webpubsub.client.implementation.models.WebPubSubMessage;
import java.io.IOException;

public final class DisconnectedMessage
extends WebPubSubMessage {
    private static final String TYPE = "system";
    private static final String EVENT = "disconnected";
    private final String reason;

    public DisconnectedMessage(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("type", TYPE).writeStringField("event", EVENT).writeStringField("message", this.reason).writeEndObject();
    }

    public static DisconnectedMessage fromJson(JsonReader jsonReader) throws IOException {
        return (DisconnectedMessage)jsonReader.readObject(reader -> {
            String reason = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("message".equals(fieldName)) {
                    reason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new DisconnectedMessage(reason);
        });
    }
}

