/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.webpubsub.client.implementation.models.WebPubSubMessageAck;
import java.io.IOException;
import java.util.Objects;

public final class SendToGroupMessage
extends WebPubSubMessageAck {
    private static final String TYPE = "sendToGroup";
    private String group;
    private Boolean noEcho = false;
    private String dataType;
    private Object data;

    public String getType() {
        return TYPE;
    }

    public String getGroup() {
        return this.group;
    }

    public SendToGroupMessage setGroup(String group) {
        this.group = group;
        return this;
    }

    @Override
    public SendToGroupMessage setAckId(Long ackId) {
        super.setAckId(ackId);
        return this;
    }

    public Boolean isNoEcho() {
        return this.noEcho;
    }

    public SendToGroupMessage setNoEcho(Boolean noEcho) {
        this.noEcho = noEcho;
        return this;
    }

    public String getDataType() {
        return this.dataType;
    }

    public SendToGroupMessage setDataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    public Object getData() {
        return this.data;
    }

    public SendToGroupMessage setData(Object data) {
        this.data = data;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("type", TYPE).writeNumberField("ackId", (Number)this.getAckId()).writeStringField("group", this.group).writeBooleanField("noEcho", this.noEcho).writeStringField("dataType", this.dataType).writeStringField("data", Objects.toString(this.data, null)).writeEndObject();
    }

    public static SendToGroupMessage fromJson(JsonReader jsonReader) throws IOException {
        return (SendToGroupMessage)jsonReader.readObject(reader -> {
            SendToGroupMessage sendToGroupMessage = new SendToGroupMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ackId".equals(fieldName)) {
                    sendToGroupMessage.setAckId((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("group".equals(fieldName)) {
                    sendToGroupMessage.group = reader.getString();
                    continue;
                }
                if ("noEcho".equals(fieldName)) {
                    sendToGroupMessage.noEcho = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("dataType".equals(fieldName)) {
                    sendToGroupMessage.dataType = reader.getString();
                    continue;
                }
                if ("data".equals(fieldName)) {
                    sendToGroupMessage.data = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return sendToGroupMessage;
        });
    }
}

