/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client.implementation;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public final class EventHandlerCollection {
    private final ConcurrentMap<String, List> collection = new ConcurrentHashMap<String, List>();

    public <T> void addEventHandler(String type, Consumer<T> eventHandler) {
        List listeners = this.collection.computeIfAbsent(type, k -> new CopyOnWriteArrayList());
        listeners.add(eventHandler);
    }

    public <T> void removeEventHandler(String type, Consumer<T> eventHandler) {
        List listeners = (List)this.collection.get(type);
        if (listeners != null) {
            listeners.remove(eventHandler);
        }
    }

    public <T> void fireEvent(String type, T event) {
        List listeners = (List)this.collection.get(type);
        if (listeners != null) {
            for (Consumer listener : listeners) {
                listener.accept(event);
            }
        }
    }
}

