/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class CloudEvent
implements JsonSerializable<CloudEvent> {
    private String id;
    private String source;
    private Object data;
    private byte[] dataBase64;
    private String type;
    private OffsetDateTime time;
    private String specversion;
    private String dataschema;
    private String datacontenttype;
    private String subject;
    private Map<String, Object> additionalProperties;

    public String getId() {
        return this.id;
    }

    public CloudEvent setId(String id) {
        this.id = id;
        return this;
    }

    public String getSource() {
        return this.source;
    }

    public CloudEvent setSource(String source) {
        this.source = source;
        return this;
    }

    public Object getData() {
        return this.data;
    }

    public CloudEvent setData(Object data) {
        this.data = data;
        return this;
    }

    public byte[] getDataBase64() {
        return CoreUtils.clone((byte[])this.dataBase64);
    }

    public CloudEvent setDataBase64(byte[] dataBase64) {
        this.dataBase64 = CoreUtils.clone((byte[])dataBase64);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public CloudEvent setType(String type) {
        this.type = type;
        return this;
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public CloudEvent setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public String getSpecversion() {
        return this.specversion;
    }

    public CloudEvent setSpecversion(String specversion) {
        this.specversion = specversion;
        return this;
    }

    public String getDataschema() {
        return this.dataschema;
    }

    public CloudEvent setDataschema(String dataschema) {
        this.dataschema = dataschema;
        return this;
    }

    public String getDatacontenttype() {
        return this.datacontenttype;
    }

    public CloudEvent setDatacontenttype(String datacontenttype) {
        this.datacontenttype = datacontenttype;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public CloudEvent setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public CloudEvent setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("specversion", this.specversion);
        if (this.data != null) {
            jsonWriter.writeUntypedField("data", this.data);
        }
        jsonWriter.writeBinaryField("data_base64", this.dataBase64);
        jsonWriter.writeStringField("time", this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        jsonWriter.writeStringField("dataschema", this.dataschema);
        jsonWriter.writeStringField("datacontenttype", this.datacontenttype);
        jsonWriter.writeStringField("subject", this.subject);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CloudEvent fromJson(JsonReader jsonReader) throws IOException {
        return (CloudEvent)jsonReader.readObject(reader -> {
            CloudEvent deserializedCloudEvent = new CloudEvent();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCloudEvent.id = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedCloudEvent.source = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCloudEvent.type = reader.getString();
                    continue;
                }
                if ("specversion".equals(fieldName)) {
                    deserializedCloudEvent.specversion = reader.getString();
                    continue;
                }
                if ("data".equals(fieldName)) {
                    deserializedCloudEvent.data = reader.readUntyped();
                    continue;
                }
                if ("data_base64".equals(fieldName)) {
                    deserializedCloudEvent.dataBase64 = reader.getBinary();
                    continue;
                }
                if ("time".equals(fieldName)) {
                    deserializedCloudEvent.time = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("dataschema".equals(fieldName)) {
                    deserializedCloudEvent.dataschema = reader.getString();
                    continue;
                }
                if ("datacontenttype".equals(fieldName)) {
                    deserializedCloudEvent.datacontenttype = reader.getString();
                    continue;
                }
                if ("subject".equals(fieldName)) {
                    deserializedCloudEvent.subject = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCloudEvent.additionalProperties = additionalProperties;
            return deserializedCloudEvent;
        });
    }
}

