/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.ContainerRegistryEventActor;
import com.azure.messaging.eventgrid.systemevents.ContainerRegistryEventConnectedRegistry;
import com.azure.messaging.eventgrid.systemevents.ContainerRegistryEventData;
import com.azure.messaging.eventgrid.systemevents.ContainerRegistryEventRequest;
import com.azure.messaging.eventgrid.systemevents.ContainerRegistryEventSource;
import com.azure.messaging.eventgrid.systemevents.ContainerRegistryEventTarget;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

@Deprecated
public final class ContainerRegistryImageDeletedEventData
extends ContainerRegistryEventData {
    @Override
    public ContainerRegistryImageDeletedEventData setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public ContainerRegistryImageDeletedEventData setTimestamp(OffsetDateTime timestamp) {
        super.setTimestamp(timestamp);
        return this;
    }

    @Override
    public ContainerRegistryImageDeletedEventData setAction(String action) {
        super.setAction(action);
        return this;
    }

    @Override
    public ContainerRegistryImageDeletedEventData setLocation(String location) {
        super.setLocation(location);
        return this;
    }

    @Override
    public ContainerRegistryImageDeletedEventData setTarget(ContainerRegistryEventTarget target) {
        super.setTarget(target);
        return this;
    }

    @Override
    public ContainerRegistryImageDeletedEventData setRequest(ContainerRegistryEventRequest request) {
        super.setRequest(request);
        return this;
    }

    @Override
    public ContainerRegistryImageDeletedEventData setActor(ContainerRegistryEventActor actor) {
        super.setActor(actor);
        return this;
    }

    @Override
    public ContainerRegistryImageDeletedEventData setSource(ContainerRegistryEventSource source) {
        super.setSource(source);
        return this;
    }

    @Override
    public ContainerRegistryImageDeletedEventData setConnectedRegistry(ContainerRegistryEventConnectedRegistry connectedRegistry) {
        super.setConnectedRegistry(connectedRegistry);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeStringField("timestamp", this.getTimestamp() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getTimestamp()));
        jsonWriter.writeStringField("action", this.getAction());
        jsonWriter.writeStringField("location", this.getLocation());
        jsonWriter.writeJsonField("target", (JsonSerializable)this.getTarget());
        jsonWriter.writeJsonField("request", (JsonSerializable)this.getRequest());
        jsonWriter.writeJsonField("actor", (JsonSerializable)this.getActor());
        jsonWriter.writeJsonField("source", (JsonSerializable)this.getSource());
        jsonWriter.writeJsonField("connectedRegistry", (JsonSerializable)this.getConnectedRegistry());
        return jsonWriter.writeEndObject();
    }

    public static ContainerRegistryImageDeletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerRegistryImageDeletedEventData)jsonReader.readObject(reader -> {
            ContainerRegistryImageDeletedEventData deserializedContainerRegistryImageDeletedEventData = new ContainerRegistryImageDeletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedContainerRegistryImageDeletedEventData.setId(reader.getString());
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedContainerRegistryImageDeletedEventData.setTimestamp((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedContainerRegistryImageDeletedEventData.setAction(reader.getString());
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedContainerRegistryImageDeletedEventData.setLocation(reader.getString());
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedContainerRegistryImageDeletedEventData.setTarget(ContainerRegistryEventTarget.fromJson(reader));
                    continue;
                }
                if ("request".equals(fieldName)) {
                    deserializedContainerRegistryImageDeletedEventData.setRequest(ContainerRegistryEventRequest.fromJson(reader));
                    continue;
                }
                if ("actor".equals(fieldName)) {
                    deserializedContainerRegistryImageDeletedEventData.setActor(ContainerRegistryEventActor.fromJson(reader));
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedContainerRegistryImageDeletedEventData.setSource(ContainerRegistryEventSource.fromJson(reader));
                    continue;
                }
                if ("connectedRegistry".equals(fieldName)) {
                    deserializedContainerRegistryImageDeletedEventData.setConnectedRegistry(ContainerRegistryEventConnectedRegistry.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerRegistryImageDeletedEventData;
        });
    }
}

