/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class StorageTaskQueuedEventData
implements JsonSerializable<StorageTaskQueuedEventData> {
    private OffsetDateTime queuedDateTime;
    private String taskExecutionId;

    public OffsetDateTime getQueuedDateTime() {
        return this.queuedDateTime;
    }

    public StorageTaskQueuedEventData setQueuedDateTime(OffsetDateTime queuedDateTime) {
        this.queuedDateTime = queuedDateTime;
        return this;
    }

    public String getTaskExecutionId() {
        return this.taskExecutionId;
    }

    public StorageTaskQueuedEventData setTaskExecutionId(String taskExecutionId) {
        this.taskExecutionId = taskExecutionId;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("queuedDateTime", this.queuedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.queuedDateTime));
        jsonWriter.writeStringField("taskExecutionId", this.taskExecutionId);
        return jsonWriter.writeEndObject();
    }

    public static StorageTaskQueuedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTaskQueuedEventData)jsonReader.readObject(reader -> {
            StorageTaskQueuedEventData deserializedStorageTaskQueuedEventData = new StorageTaskQueuedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("queuedDateTime".equals(fieldName)) {
                    deserializedStorageTaskQueuedEventData.queuedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("taskExecutionId".equals(fieldName)) {
                    deserializedStorageTaskQueuedEventData.taskExecutionId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTaskQueuedEventData;
        });
    }
}

