/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SignalRServiceClientConnectionConnectedEventData
implements JsonSerializable<SignalRServiceClientConnectionConnectedEventData> {
    private OffsetDateTime timestamp;
    private String hubName;
    private String connectionId;
    private String userId;

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public SignalRServiceClientConnectionConnectedEventData setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String getHubName() {
        return this.hubName;
    }

    public SignalRServiceClientConnectionConnectedEventData setHubName(String hubName) {
        this.hubName = hubName;
        return this;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public SignalRServiceClientConnectionConnectedEventData setConnectionId(String connectionId) {
        this.connectionId = connectionId;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public SignalRServiceClientConnectionConnectedEventData setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("hubName", this.hubName);
        jsonWriter.writeStringField("connectionId", this.connectionId);
        jsonWriter.writeStringField("userId", this.userId);
        return jsonWriter.writeEndObject();
    }

    public static SignalRServiceClientConnectionConnectedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (SignalRServiceClientConnectionConnectedEventData)jsonReader.readObject(reader -> {
            SignalRServiceClientConnectionConnectedEventData deserializedSignalRServiceClientConnectionConnectedEventData = new SignalRServiceClientConnectionConnectedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timestamp".equals(fieldName)) {
                    deserializedSignalRServiceClientConnectionConnectedEventData.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("hubName".equals(fieldName)) {
                    deserializedSignalRServiceClientConnectionConnectedEventData.hubName = reader.getString();
                    continue;
                }
                if ("connectionId".equals(fieldName)) {
                    deserializedSignalRServiceClientConnectionConnectedEventData.connectionId = reader.getString();
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedSignalRServiceClientConnectionConnectedEventData.userId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSignalRServiceClientConnectionConnectedEventData;
        });
    }
}

