/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class ResourceNotificationsResourceUpdatedDetails
implements JsonSerializable<ResourceNotificationsResourceUpdatedDetails> {
    private String id;
    private String name;
    private String type;
    private String location;
    private Map<String, String> tags;
    private Map<String, Object> properties;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceNotificationsResourceUpdatedDetails.class);

    public String getId() {
        return this.id;
    }

    public ResourceNotificationsResourceUpdatedDetails setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ResourceNotificationsResourceUpdatedDetails setName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public ResourceNotificationsResourceUpdatedDetails setType(String type) {
        this.type = type;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public ResourceNotificationsResourceUpdatedDetails setLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> getResourceTags() {
        return this.tags;
    }

    public ResourceNotificationsResourceUpdatedDetails setResourceTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public ResourceNotificationsResourceUpdatedDetails setProperties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceNotificationsResourceUpdatedDetails fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceNotificationsResourceUpdatedDetails)jsonReader.readObject(reader -> {
            ResourceNotificationsResourceUpdatedDetails deserializedResourceNotificationsResourceUpdatedDetails = new ResourceNotificationsResourceUpdatedDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedResourceNotificationsResourceUpdatedDetails.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedResourceNotificationsResourceUpdatedDetails.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedResourceNotificationsResourceUpdatedDetails.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedResourceNotificationsResourceUpdatedDetails.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedResourceNotificationsResourceUpdatedDetails.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedResourceNotificationsResourceUpdatedDetails.properties = properties = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceNotificationsResourceUpdatedDetails;
        });
    }

    @Deprecated
    public String getTags() {
        LOGGER.log(LogLevel.INFORMATIONAL, () -> "This method has been replaced with getResourceTags().");
        return null;
    }

    @Deprecated
    public ResourceNotificationsResourceUpdatedDetails setTags(String tags) {
        LOGGER.log(LogLevel.INFORMATIONAL, () -> "This method has been replaced with setResourceTags(Map).");
        return this;
    }
}

