/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.ResourceAuthorization;
import com.azure.messaging.eventgrid.systemevents.ResourceHttpRequest;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;

public final class ResourceDeleteFailureEventData
implements JsonSerializable<ResourceDeleteFailureEventData> {
    private String tenantId;
    private String subscriptionId;
    private String resourceGroup;
    private String resourceProvider;
    private String resourceUri;
    private String operationName;
    private String status;
    private ResourceAuthorization authorization;
    private Map<String, String> claims;
    private String correlationId;
    private ResourceHttpRequest httpRequest;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceDeleteFailureEventData.class);
    private static final SerializerAdapter DEFAULT_SERIALIZER_ADAPTER = JacksonAdapter.createDefaultSerializerAdapter();

    public String getTenantId() {
        return this.tenantId;
    }

    public ResourceDeleteFailureEventData setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public ResourceDeleteFailureEventData setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public ResourceDeleteFailureEventData setResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return this;
    }

    public String getResourceProvider() {
        return this.resourceProvider;
    }

    public ResourceDeleteFailureEventData setResourceProvider(String resourceProvider) {
        this.resourceProvider = resourceProvider;
        return this;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public ResourceDeleteFailureEventData setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
        return this;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public ResourceDeleteFailureEventData setOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public ResourceDeleteFailureEventData setStatus(String status) {
        this.status = status;
        return this;
    }

    public ResourceAuthorization getResourceAuthorization() {
        return this.authorization;
    }

    public ResourceDeleteFailureEventData setResourceAuthorization(ResourceAuthorization authorization) {
        this.authorization = authorization;
        return this;
    }

    public Map<String, String> getResourceClaims() {
        return this.claims;
    }

    public ResourceDeleteFailureEventData setResourceClaims(Map<String, String> claims) {
        this.claims = claims;
        return this;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public ResourceDeleteFailureEventData setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public ResourceHttpRequest getResourceHttpRequest() {
        return this.httpRequest;
    }

    public ResourceDeleteFailureEventData setResourceHttpRequest(ResourceHttpRequest httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tenantId", this.tenantId);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("resourceGroup", this.resourceGroup);
        jsonWriter.writeStringField("resourceProvider", this.resourceProvider);
        jsonWriter.writeStringField("resourceUri", this.resourceUri);
        jsonWriter.writeStringField("operationName", this.operationName);
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeJsonField("authorization", (JsonSerializable)this.authorization);
        jsonWriter.writeMapField("claims", this.claims, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("correlationId", this.correlationId);
        jsonWriter.writeJsonField("httpRequest", (JsonSerializable)this.httpRequest);
        return jsonWriter.writeEndObject();
    }

    public static ResourceDeleteFailureEventData fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceDeleteFailureEventData)jsonReader.readObject(reader -> {
            ResourceDeleteFailureEventData deserializedResourceDeleteFailureEventData = new ResourceDeleteFailureEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tenantId".equals(fieldName)) {
                    deserializedResourceDeleteFailureEventData.tenantId = reader.getString();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedResourceDeleteFailureEventData.subscriptionId = reader.getString();
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedResourceDeleteFailureEventData.resourceGroup = reader.getString();
                    continue;
                }
                if ("resourceProvider".equals(fieldName)) {
                    deserializedResourceDeleteFailureEventData.resourceProvider = reader.getString();
                    continue;
                }
                if ("resourceUri".equals(fieldName)) {
                    deserializedResourceDeleteFailureEventData.resourceUri = reader.getString();
                    continue;
                }
                if ("operationName".equals(fieldName)) {
                    deserializedResourceDeleteFailureEventData.operationName = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedResourceDeleteFailureEventData.status = reader.getString();
                    continue;
                }
                if ("authorization".equals(fieldName)) {
                    deserializedResourceDeleteFailureEventData.authorization = ResourceAuthorization.fromJson(reader);
                    continue;
                }
                if ("claims".equals(fieldName)) {
                    Map claims;
                    deserializedResourceDeleteFailureEventData.claims = claims = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("correlationId".equals(fieldName)) {
                    deserializedResourceDeleteFailureEventData.correlationId = reader.getString();
                    continue;
                }
                if ("httpRequest".equals(fieldName)) {
                    deserializedResourceDeleteFailureEventData.httpRequest = ResourceHttpRequest.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceDeleteFailureEventData;
        });
    }

    @Deprecated
    public String getClaims() {
        Map<String, String> resourceClaims = this.getResourceClaims();
        if (!resourceClaims.isEmpty()) {
            try {
                return DEFAULT_SERIALIZER_ADAPTER.serialize(resourceClaims, SerializerEncoding.JSON);
            }
            catch (IOException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
            }
        }
        return null;
    }

    @Deprecated
    public ResourceDeleteFailureEventData setClaims(String claims) {
        try {
            this.setResourceClaims((Map)DEFAULT_SERIALIZER_ADAPTER.deserialize(claims, Map.class, SerializerEncoding.JSON));
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
        return this;
    }

    @Deprecated
    public String getHttpRequest() {
        ResourceHttpRequest resourceHttpRequest = this.getResourceHttpRequest();
        try {
            return DEFAULT_SERIALIZER_ADAPTER.serialize((Object)resourceHttpRequest, SerializerEncoding.JSON);
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    @Deprecated
    public ResourceDeleteFailureEventData setHttpRequest(String httpRequest) {
        try {
            this.setResourceHttpRequest((ResourceHttpRequest)DEFAULT_SERIALIZER_ADAPTER.deserialize(httpRequest, ResourceHttpRequest.class, SerializerEncoding.JSON));
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
        return this;
    }

    @Deprecated
    public String getAuthorization() {
        ResourceAuthorization resourceAuthorization = this.getResourceAuthorization();
        try {
            return DEFAULT_SERIALIZER_ADAPTER.serialize((Object)resourceAuthorization, SerializerEncoding.JSON);
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    @Deprecated
    public ResourceDeleteFailureEventData setAuthorization(String authorization) {
        try {
            this.setResourceAuthorization((ResourceAuthorization)DEFAULT_SERIALIZER_ADAPTER.deserialize(authorization, ResourceAuthorization.class, SerializerEncoding.JSON));
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
        return this;
    }
}

