/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.ContainerRegistryEventActor;
import com.azure.messaging.eventgrid.systemevents.ContainerRegistryEventConnectedRegistry;
import com.azure.messaging.eventgrid.systemevents.ContainerRegistryEventRequest;
import com.azure.messaging.eventgrid.systemevents.ContainerRegistryEventSource;
import com.azure.messaging.eventgrid.systemevents.ContainerRegistryEventTarget;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class ContainerRegistryEventData
implements JsonSerializable<ContainerRegistryEventData> {
    private String id;
    private OffsetDateTime timestamp;
    private String action;
    private String location;
    private ContainerRegistryEventTarget target;
    private ContainerRegistryEventRequest request;
    private ContainerRegistryEventActor actor;
    private ContainerRegistryEventSource source;
    private ContainerRegistryEventConnectedRegistry connectedRegistry;

    public String getId() {
        return this.id;
    }

    public ContainerRegistryEventData setId(String id) {
        this.id = id;
        return this;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public ContainerRegistryEventData setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String getAction() {
        return this.action;
    }

    public ContainerRegistryEventData setAction(String action) {
        this.action = action;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public ContainerRegistryEventData setLocation(String location) {
        this.location = location;
        return this;
    }

    public ContainerRegistryEventTarget getTarget() {
        return this.target;
    }

    public ContainerRegistryEventData setTarget(ContainerRegistryEventTarget target) {
        this.target = target;
        return this;
    }

    public ContainerRegistryEventRequest getRequest() {
        return this.request;
    }

    public ContainerRegistryEventData setRequest(ContainerRegistryEventRequest request) {
        this.request = request;
        return this;
    }

    public ContainerRegistryEventActor getActor() {
        return this.actor;
    }

    public ContainerRegistryEventData setActor(ContainerRegistryEventActor actor) {
        this.actor = actor;
        return this;
    }

    public ContainerRegistryEventSource getSource() {
        return this.source;
    }

    public ContainerRegistryEventData setSource(ContainerRegistryEventSource source) {
        this.source = source;
        return this;
    }

    public ContainerRegistryEventConnectedRegistry getConnectedRegistry() {
        return this.connectedRegistry;
    }

    public ContainerRegistryEventData setConnectedRegistry(ContainerRegistryEventConnectedRegistry connectedRegistry) {
        this.connectedRegistry = connectedRegistry;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("action", this.action);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("target", (JsonSerializable)this.target);
        jsonWriter.writeJsonField("request", (JsonSerializable)this.request);
        jsonWriter.writeJsonField("actor", (JsonSerializable)this.actor);
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        jsonWriter.writeJsonField("connectedRegistry", (JsonSerializable)this.connectedRegistry);
        return jsonWriter.writeEndObject();
    }

    public static ContainerRegistryEventData fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerRegistryEventData)jsonReader.readObject(reader -> {
            ContainerRegistryEventData deserializedContainerRegistryEventData = new ContainerRegistryEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedContainerRegistryEventData.id = reader.getString();
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedContainerRegistryEventData.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedContainerRegistryEventData.action = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedContainerRegistryEventData.location = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedContainerRegistryEventData.target = ContainerRegistryEventTarget.fromJson(reader);
                    continue;
                }
                if ("request".equals(fieldName)) {
                    deserializedContainerRegistryEventData.request = ContainerRegistryEventRequest.fromJson(reader);
                    continue;
                }
                if ("actor".equals(fieldName)) {
                    deserializedContainerRegistryEventData.actor = ContainerRegistryEventActor.fromJson(reader);
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedContainerRegistryEventData.source = ContainerRegistryEventSource.fromJson(reader);
                    continue;
                }
                if ("connectedRegistry".equals(fieldName)) {
                    deserializedContainerRegistryEventData.connectedRegistry = ContainerRegistryEventConnectedRegistry.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerRegistryEventData;
        });
    }
}

